--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Standard_Random;

package body Nomo.Interpreter.External_Messages.Premises.Feedback is

   procedure Get_Information (Premise     : in External_Premise;
                              Information : out External_Message) is
   begin
      for I in 1 .. Premise.Size loop
         if Premise.Tolerance(I) /= Positive_Infinity then
            Information (I) := Premise.Information (I);
         end if;
      end loop;
   end Get_Information;


   procedure Get_Random_Information (Premise     : in External_Premise;
                                     Information : out External_Message) is
      use Standard_Random;
   begin
      for I in 1 .. Premise.Size loop
         if Premise.Tolerance (I) = Zero_Plus then
            Information (I) := Premise.Information (I);
         elsif Premise.Tolerance (I) = Positive_Infinity then
            Information (I) := Real( Random_Gaussian (0.0, Float (Rand_Max)));
         else
            Information (I) := Real( Random_Gaussian (Float (Premise.Information (I)), Float (Premise.Tolerance (I))));
         end if;
      end loop;
   end Get_Random_Information;

end Nomo.Interpreter.External_Messages.Premises.Feedback;
