<?xml version="1.0" encoding="utf-8" standalone="yes"?>
<!--
  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program. If not, see <http://www.gnu.org/licenses/>
-->
<xsl:stylesheet version="1.0" exclude-result-prefixes="ws" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:ws="http://www.nomoseed.org/worldsquare" xmlns:svg="http://www.w3.org/2000/svg">
	<xsl:output method="xml" doctype-public="-//W3C//DTD SVG 1.1//EN" standalone="no" doctype-system="http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd" indent="yes" encoding="utf-8"/>
	<xsl:variable name="xMax">
		<xsl:for-each select="/ws:worldsquare/ws:square">
			<xsl:sort select="@x" data-type="number" order="descending"/>
			<xsl:if test="position() = 1">
				<xsl:value-of select="@x"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="yMax">
		<xsl:for-each select="/ws:worldsquare/ws:square">
			<xsl:sort select="@y" data-type="number" order="descending"/>
			<xsl:if test="position() = 1">
				<xsl:value-of select="@y"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="dx" select="50"/>
	<xsl:variable name="dy" select="24"/>
	<xsl:variable name="hView" select="($xMax + $yMax + 4)*$dy"/>
	<xsl:variable name="wView" select="($xMax + $yMax + 2)*$dx"/>
	<xsl:variable name="shiftX" select="($wView - $dx) div 2"/>
	<xsl:template match="ws:worldsquare">
		<svg:svg>
			<xsl:if test="ws:sum_sounds/@value">
				<svg:svg viewBox="0 0 {$wView} {$hView}" preserveAspectRatio="xMin* silice">
					<svg:rect x="0" y="0" width="{$wView}" height="{$hView}" fill="none" stroke="none"/>
					<svg:g>
						<svg:circle cx="20" cy="20" r="10" visibility="hidden"/>
						<svg:path d="m 21.920311,0 a 21.920311,22.273863 0 0 1 -21.92031,22.27387" fill="none" stroke="hsl({ws:sum_sounds/@value}, 100%, 50%)" stroke-width="5"/>
						<svg:animate attributeName="stroke-opacity" attributeType="CSS" values="1;0" begin="0s" dur="1s" restart="never" fill="freeze"/>
						<svg:animateTransform attributeName="transform" type="scale" from="0.1" to="40" begin="0s" dur="1s" restart="never" fill="freeze"/>
					</svg:g>
				</svg:svg>
			</xsl:if>
			<svg:svg viewBox="0 0 {$wView} {$hView}" preserveAspectRatio="xMidYMid meet">
				<svg:desc>
					<xsl:value-of select="@name"/>
				</svg:desc>
				<svg:defs>
					<svg:g id="square" stroke="#000" stroke-width="1">
						<svg:polygon fill-opacity="1" points="-50,0 0,24 50,0 0,-24"/>
						<svg:polygon fill-opacity="0.6" points="50,0 50,16 0,40 0,24"/>
						<svg:polygon fill-opacity="0.2" points="0,40 0,24 -50,0 -50,16"/>
					</svg:g>
					<svg:polygon id="head_0" points="-50,0 0,24 26,-11" stroke-linejoin="round" stroke-width="5"/>
					<svg:polygon id="head_90" points="26,11 -50,0 0,-24" stroke-linejoin="round" stroke-width="5"/>
					<svg:polygon id="head_180" points="50,0 0,-24 -26,11" stroke-linejoin="round" stroke-width="5"/>
					<svg:polygon id="head_270" points="-26,-11 50,0 0,24" stroke-linejoin="round" stroke-width="5"/>
					<svg:g id="body" stroke="#777" stroke-width="1">
						<svg:use xlink:href="#back_directions"/>
						<svg:polygon fill="#111" points="-50,0 0,24 50,0 0,-24"/>
						<svg:polygon fill="#666" points="50,0 50,16 0,40 0,24"/>
						<svg:polygon fill="#333" points="0,40 0,24 -50,0 -50,16"/>
						<svg:use xlink:href="#front_directions"/>
					</svg:g>
					<svg:g id="front_directions" transform="scale(0.7) translate(-1.5003527,-1045)" style="opacity:0.89166667;fill:#ffff1c;fill-opacity:1;fill-rule:nonzero;stroke:none">
						<svg:path d="m 73.425311,1061.6555 c 5.67097,3.0748 8.7924,9.1865 10.65135,15.5182 1.81404,6.1787 4.05746,11.4361 -2.27354,14.7669 -6.33097,3.3308 -24.10421,4.7206 -30.50327,3.9045 -4.58954,-0.5854 -31.7949,0.237 -31.13491,-6.1686 0.66,-6.4055 12.16705,-13.531 18.49802,-16.8618 6.33097,-3.3309 29.09137,-14.2339 34.76235,-11.1592 z"/>
						<svg:path d="m -71.119043,1061.6703 c -5.64051,3.1302 -8.70177,9.2723 -10.49847,15.6219 -1.75327,6.1962 -3.94497,11.4754 2.41842,14.7439 6.36337,3.2685 24.1494,4.4838 30.54014,3.6048 4.58356,-0.6304 31.795694,-0.075 31.072844,-6.4739 -0.72286,-6.3988 -12.299324,-13.4109 -18.662684,-16.6794 -6.36338,-3.2686 -29.22973,-13.9476 -34.87025,-10.8173 z"/>
					</svg:g>
					<svg:g id="back_directions" transform="scale(0.7) translate(-1.5003527,-1045)" style="opacity:0.89166667;fill:#ffff1c;fill-opacity:1;fill-rule:nonzero;stroke:none">
						<svg:path d="m -65.626593,1044.4678 c -5.33567,-3.6256 -7.83133,-10.0184 -9.04887,-16.504 -1.18811,-6.3289 -2.89545,-11.784 3.73645,-14.4662 6.63188,-2.6821 24.45508,-2.2906 30.74068,-0.8396 4.50817,1.0406 31.6597139,2.9384 30.3635239,9.2461 -1.2962099,6.3076 -13.4571399,12.2487 -20.0890239,14.9308 -6.63188,2.6821 -30.36709,11.2584 -35.70276,7.6329 z"/>
						<svg:path d="m 67.451031,1046.2058 c 5.47398,-3.4132 8.21888,-9.703 9.69028,-16.1358 1.43586,-6.2773 3.35619,-11.6611 -3.16521,-14.6017 -6.52139,-2.9407 -24.3462,-3.2497 -30.68396,-2.0468 -4.54557,0.8627 -31.75071,1.6923 -30.70334,8.046 1.0474,6.3538 12.96554,12.768 19.4869,15.7086 6.52139,2.9406 29.90133,12.4428 35.37533,9.0297 z"/>
					</svg:g>
					<svg:rect id="slab" style="opacity:0.89166667;fill:#ffff1c;fill-opacity:0.5;stroke:red" width="55" height="55" x="-45" y="-08" rx="10" ry="10" transform="matrix(0.89837819,-0.43922274,0.89837819,0.43922274,0,0)"/>
					<svg:polygon id="slab2" fill="none" stroke="#777" stroke-width="3" stroke-linejoin="round" points="-50,0 0,24 50,0 0,-24"/>
					<xsl:if test="ws:sphere">
						<svg:g id="sphere" transform="scale(0.5, 0.5) translate(-100, -125)">
							<svg:linearGradient id="linearGradientSphere">
								<svg:stop style="stop-color:#fff;stop-opacity:1.0" offset="0.0"/>
								<svg:stop style="stop-color:#000;stop-opacity:1.0" offset="1.0"/>
							</svg:linearGradient>
							<svg:radialGradient cx="100" cy="100" r="20" fx="100" fy="100" id="radialGradientSphere" xlink:href="#linearGradientSphere" gradientUnits="userSpaceOnUse" gradientTransform="matrix(1.0,0.8,-0.8,1.0,95,-95)"/>
							<svg:filter id="Shadow" filterUnits="userSpaceOnUse" x="-5" y="-5" width="200" height="200">
								<svg:feGaussianBlur id="blur" in="SourceGraphic" stdDeviation="10" result="flou"/>
							</svg:filter>
							<svg:circle cx="100" cy="100" r="20" fill="url(#radialGradientSphere)"/>
							<svg:ellipse cx="80" cy="140" rx="25" ry="10" fill="blak" filter="url(#Shadow)"/>
						</svg:g>
					</xsl:if>
				</svg:defs>
				<svg:rect id="background" x="0" y="0" width="{$wView}" height="{$hView}" fill="none" stroke="none" preserveAspectRatio="xMidYMid"/>
				<xsl:call-template name="slabs">
					<xsl:with-param name="x" select="0"/>
					<xsl:with-param name="y" select="0"/>
				</xsl:call-template>
				<xsl:for-each select="ws:square">
					<xsl:sort data-type="number" order="ascending" select="(@x * 10 + @y)"/>
					<svg:use xlink:href="#square" x="{(@x - @y)*$dx + $shiftX}" y="{(@x + @y + 1)*$dy}" fill="hsl({@hue}, 100%, 50%)"/>
				</xsl:for-each>
				<xsl:for-each select="ws:sphere">
					<xsl:sort data-type="number" order="ascending" select="(number(@x) * 10 + number(@y))"/>
					<svg:use xlink:href="#sphere" x="{(@x - @y)*$dx + $shiftX}" y="{(@x + @y + 1)*$dy}"/>
				</xsl:for-each>
				<xsl:for-each select="ws:agent">
					<xsl:sort data-type="number" order="ascending" select="(@x * 10 + @y)"/>
					<svg:g transform="translate ({(@x - @y)*$dx + $shiftX}, {(@x + @y + 1)*$dy - 16})">
						<svg:use xlink:href="#body"/>
						<xsl:choose>
							<xsl:when test="ws:turn_right">
								<xsl:choose>
									<xsl:when test="@direction = 90">
										<svg:path transform="scale(0.5)" stroke="hsl({@hue}, 100%, 50%)">
											<svg:animate attributeName="d" attributeType="XML" from="M -50,0 L 0,24 L 26,-11 Z" to="M 0,-24 L -50,0 L 26,11 Z" begin="0" dur="0.6s" restart="never" fill="freeze"/>
										</svg:path>
									</xsl:when>
									<xsl:when test="@direction = 180">
										<svg:path transform="scale(0.5)" stroke="hsl({@hue}, 100%, 50%)">
											<svg:animate attributeName="d" attributeType="XML" from="M 26,11 L -50,0 L 0,-24 Z" to="M -26,11 L 0,-24 L 50,0 Z" begin="0" dur="0.6s" restart="never" fill="freeze"/>
										</svg:path>
									</xsl:when>
									<xsl:when test="@direction = 270">
										<svg:path transform="scale(0.5)" stroke="hsl({@hue}, 100%, 50%)">
											<svg:animate attributeName="d" attributeType="XML" from="M -26,11 L 0,-24 L 50,0 Z" to="M -26,-11 L 50,0 L 0,24 Z" begin="0" dur="0.6s" restart="never" fill="freeze"/>
										</svg:path>
									</xsl:when>
									<xsl:when test="@direction = 0">
										<svg:path transform="scale(0.5)" stroke="hsl({@hue}, 100%, 50%)">
											<svg:animate attributeName="d" attributeType="XML" from="M -26,-11 L 50,0 L 0,24 Z" to="M 26,-11 L 0,24 L -50,0 Z" begin="0" dur="0.6s" restart="never" fill="freeze"/>
										</svg:path>
									</xsl:when>
								</xsl:choose>
							</xsl:when>
							<xsl:when test="ws:turn_left">
								<xsl:choose>
									<xsl:when test="@direction = 0">
										<svg:path transform="scale(0.5)" stroke="hsl({@hue}, 100%, 50%)">
											<svg:animate attributeName="d" attributeType="XML" from="M 0,-24 L -50,0 L 26,11 Z" to="M -50,0 L 0,24 L 26,-11 Z" begin="0" dur="0.6s" restart="never" fill="freeze"/>
										</svg:path>
									</xsl:when>
									<xsl:when test="@direction = 90">
										<svg:path transform="scale(0.5)" stroke="hsl({@hue}, 100%, 50%)">
											<svg:animate attributeName="d" attributeType="XML" from="M -26,11 L 0,-24 L 50,0 Z" to="M 26,11 L -50,0 L 0,-24 Z" begin="0" dur="0.6s" restart="never" fill="freeze"/>
										</svg:path>
									</xsl:when>
									<xsl:when test="@direction = 180">
										<svg:path transform="scale(0.5)" stroke="hsl({@hue}, 100%, 50%)">
											<svg:animate attributeName="d" attributeType="XML" from="M -26,-11 L 50,0 L 0,24 Z" to="M -26,11 L 0,-24 L 50,0 Z" begin="0" dur="0.6s" restart="never" fill="freeze"/>
										</svg:path>
									</xsl:when>
									<xsl:when test="@direction = 270">
										<svg:path transform="scale(0.5)" stroke="hsl({@hue}, 100%, 50%)">
											<svg:animate attributeName="d" attributeType="XML" from="M 26,-11 L 0,24 L -50,0 Z" to="M -26,-11 L 50,0 L 0,24 Z" begin="0" dur="0.6s" restart="never" fill="freeze"/>
										</svg:path>
									</xsl:when>
								</xsl:choose>
							</xsl:when>
							<xsl:when test="ws:advance/@old_x">
								<svg:use xlink:href="#head_{@direction}" transform="scale(0.5)" stroke="hsl({@hue}, 100%, 50%)"/>
								<svg:animateTransform attributeName="transform" type="translate" from="{(ws:advance/@old_x - ws:advance/@old_y)*$dx + $shiftX}, {(ws:advance/@old_x + ws:advance/@old_y + 1)*$dy - 16}" to="{(@x - @y)*$dx + $shiftX}, {(@x + @y + 1)*$dy - 16}" begin="0" dur="0.4s" restart="never" fill="freeze"/>
							</xsl:when>
							<xsl:otherwise>
								<svg:use xlink:href="#head_{@direction}" transform="scale(0.5)" stroke="hsl({@hue}, 100%, 50%)"/>
							</xsl:otherwise>
						</xsl:choose>
					</svg:g>
				</xsl:for-each>
			</svg:svg>
		</svg:svg>
	</xsl:template>
	<xsl:template name="slabs">
		<xsl:param name="x"/>
		<xsl:param name="y"/>
		<svg:use xlink:href="#slab" transform="translate ({($x - $y)*$dx + $shiftX}, {($x + $y + 1)*$dy }) "/>
		<xsl:choose>
			<xsl:when test="$yMax + 1 = $y and $xMax + 1 = $x"/>
			<xsl:when test="$xMax + 1 = $x">
				<xsl:call-template name="slabs">
					<xsl:with-param name="x" select="0"/>
					<xsl:with-param name="y" select="$y + 1"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:call-template name="slabs">
					<xsl:with-param name="x" select="$x + 1"/>
					<xsl:with-param name="y" select="$y"/>
				</xsl:call-template>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
