//  Copyright (2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published
//  by the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program. If not, see <http://www.gnu.org/licenses/>

#include "benchmark.h"
#include "pointsscatter.h"
#include "nomointerpreter.h"
#include <string.h>

static nomoLogFlag * logFlags;

void benchmarkInputs (){
    float* data = getDataPointsscatterCSV();
    if (data) {
        nomoInput(INPUT_LABEL_POINTSSCATTER_ID, &data[1]);
        nomoInput(INPUT_POINT_POINTSSCATTER_ID, &data[2]);
    }
}


void benchmarkTriggers (){
    assumePointsscatterCSV ();
    benchmarkInputs ();
    nomoTriggers ();
}

void benchmarkTriggersWithLog (const nomoLogFlag logFlag, const nomoLogPositionFlag logPositionFlag, const nomoFileFlag fileFlag){
    if (logFlag != logFlags[0]){
        int i;
        for (i=0;i<1000;i++)
            logFlags[i] = logFlag;
    }
    assumePointsscatterCSV ();
    benchmarkInputs ();
    nomoTriggersWithLog (logFlags, logPositionFlag, fileFlag);
}

void benchmarkTriggersWithSave (){
    assumePointsscatterCSV ();
    benchmarkInputs ();
    nomoTriggers ();
}

void benchmarkTriggersWithLogWithSave (const nomoLogFlag logFlag, const nomoLogPositionFlag logPositionFlag, const nomoFileFlag fileFlag){
    if (logFlag != logFlags[0]){
        int i;
        for (i=0;i<1000;i++)
            logFlags[i] = logFlag;
    }
    assumePointsscatterCSV ();
    benchmarkInputs ();
    nomoTriggersWithLog (logFlags, logPositionFlag, fileFlag);
}

static nomoCallback * benchmarkCallbacks;

void benchmarkInitialize (const char* dirData, const char* dirLog, const int dirLength){
    int i;
    logFlags = (nomoLogFlag*) malloc (sizeof(nomoLogFlag)*1000);
    benchmarkCallbacks = (nomoCallback*) malloc(sizeof(nomoCallback)*100);
    for (i=0;i<1000;i++)
        logFlags[i] = NOMO_NO_LOG;
    if (initPointsscatterCSV(dirData)){
        for(i=0;i<100;i+=2){
            benchmarkCallbacks[i] = &commandLabelPointsscatterCSV;
            benchmarkCallbacks[i+1] = &commandPointPointsscatterCSV;
        }
        nomoInitialize(benchmarkCallbacks, dirLog, dirLength);
    }
}

void benchmarkFinalize (const nomoFinalizationFlag finalizationFlag){
    cleanPointsscatterCSV();
    nomoFinalize(finalizationFlag);
    free(logFlags);
}
