--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Type_Categories;

with Nomo.Gen_Types_Index;

private generic
   with package Types_Index_Instance is new Gen_Types_Index(<>);
package Nomo.Gen_Types_Directories is

   pragma Pure;

   use Type_Categories;

   use Types_Index_Instance;

   type Type_Properties is record
      Category              : Type_Category;
      Data_Size             : Positive := 1;
      Predicted_By          : Type_Index := Type_Index'First;
      Rewarded_By           : Type_Index := Type_Index'First;
      Twined_With           : Type_Index := Type_Index'First;
      Input_Associated      : Type_Index := Type_Index'First;
      Command_Associated    : Type_Index := Type_Index'First;
      Perception_Associated : Type_Index := Type_Index'First;
      Check_Associated      : Type_Index := Type_Index'First;
      Landmark_Associated   : Type_Index := Type_Index'First;
   end record;

   type Types_Directory is array (Type_Index_Strict) of Type_Properties;

end Nomo.Gen_Types_Directories;
