--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.External_Messages.Conclusions;

with Nomo.Interpreter.Perception_Rules.Feedback;

package body Nomo.Interpreter.Command_Rules is

   procedure Adjust (This            : in out Command_Rule;
                     Specificity_Log : in out Real_Accurately) is
   begin
      if This.Is_Updatable then
         Adjust (Spontaneous_Rule (This));
      end if;
      if This.Condition.Is_Optimizable then
         This.Condition.Maximize;
         Specificity_Log := This.Condition.Get_Specificity_Log;
      end if;
      This.Internal_Conclusion.Set_Credibility (This.Condition.Get_Credibility);
   end Adjust;

   procedure Evaluate (This  : in out Command_Rule;
                       Score : out Positive_Real) is
   begin
      This.Condition.Evaluate;
      Score := This.Condition.Get_Score;
   end Evaluate;

   procedure Evaluate (This  : in out Command_Rule;
                       Shift : in Real_Accurately;
                       Score : out Positive_Real) is
   begin
      This.Condition.Evaluate (Shift);
      Score := This.Condition.Get_Score;
   end Evaluate;

   function Get_External_Conclusion (This : in Command_Rule) return System.Address is
      use External_Messages.Conclusions;
   begin
      return Get_Address (This.External_Conclusion);
   end Get_External_Conclusion;

   function Get_Internal_Conclusion (This : in Command_Rule) return not null access constant Internal_Messages.Internal_Message is
   begin
      return Internal_Message (This.Internal_Conclusion)'Unchecked_Access;
   end Get_Internal_Conclusion;

   function Get_Intensity (This : in Command_Rule) return Real_0_To_1 is

   begin
      return This.Condition.Get_Credibility;
   end Get_Intensity;

   function Is_Forget (This : in Command_Rule) return Boolean is
      use Rules_Base;
   begin
      return Rule_Base (This).Is_Forget;
   end Is_Forget;

   function Is_Updatable (This : in Command_Rule) return Boolean is
      use Rules_Base;
   begin
      return Rule_Base (This).Is_Updatable;
   end Is_Updatable;

   function Is_Upgradable (This : in Command_Rule) return Boolean is
   begin
      return This.Is_Upgradable;
   end Is_Upgradable;

   procedure Reinforce (This     : in out Command_Rule;
                        Quantity : in Real_Accurately_0_To_1) is
   begin
      Spontaneous_Rule (This).Reinforce (Quantity);
   end Reinforce;

   procedure Update_External_Conclusion (This : in out Command_Rule) is
      use Perception_Rules.Feedback;
   begin
      pragma Assert (This.Linked_Perception /= null);
      if Is_Optimizable (This.Linked_Perception, This.Internal_Conclusion.Get_Information) then
         Get_Feedback (This.Linked_Perception, This.External_Conclusion'Unchecked_Access);
      else
         This.Is_Upgradable := False;
         Get_Last_Feedback (This.Linked_Perception, This.External_Conclusion'Unchecked_Access, This.Internal_Conclusion.Get_Information);
      end if;
   end Update_External_Conclusion;

   procedure Update_Relevance (This : in out Command_Rule) is
   begin
      Spontaneous_Rule (This).Update_Relevance;
   end Update_Relevance;

   procedure Update_Relevance (This       : in out Command_Rule;
                               Scores_Sum : in Positive_Real) is
   begin
      if Scores_Sum /= 0.0 then
         Spontaneous_Rule (This).Update_Relevance (Real_Accurately_0_To_1 (This.Condition.Get_Score / Scores_Sum));
      else
         Spontaneous_Rule (This).Update_Relevance;
      end if;
   end Update_Relevance;

end Nomo.Interpreter.Command_Rules;
