--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Conditions_Base.Initialization;

with Nomo.Interpreter.Conditions_Base.Perceptive;

with Nomo.Interpreter.External_Messages.Premises.Setting;

package body Nomo.Interpreter.Perception_Conditions.Initialization is

   procedure Initialize (This                       : in out Perception_Condition;
                         Premises                   : in Internal_Premises;
                         Premises_Types             : in Internal_Premises_Types;
                         Properties                 : in Internal_Premises_Properties;
                         Premises_Number            : in Premise_Index;
                         Fitting_Nbr                : in Count;
                         Matchmaker_Ptr             : not null access Internal_Events_Index.Matchmakers.Matchmaker;
                         Excitatory_Specificity_Log : out Real_Accurately;
                         Inhibitory_Specificity_Log : out Real_Accurately;
                         External_Data              : in External_Premise;
                         External_Type              : in External_Type_Index) is
      use Conditions_Base.Initialization;
      use External_Messages.Premises.Setting;
      use Conditions_Base.Perceptive;
   begin
      Initialize (Condition_Base (This),
                  Premises,
                  Premises_Types,
                  Properties,
                  Premises_Number,
                  Fitting_Nbr,
                  Matchmaker_Ptr,
                  Excitatory_Specificity_Log,
                  Inhibitory_Specificity_Log);
      Set (This.Input_Premise, External_Data);
      This.Input_Type := External_Type;
      Adjust_Specificity_Log (This, This.Input_Premise.Get_Specificity_Log);
      Excitatory_Specificity_Log := This.Get_Specificity_Log;
   end Initialize;

end Nomo.Interpreter.Perception_Conditions.Initialization;
