--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Reader.Parameters;
pragma Elaborate_All (Nomo.Reader.Parameters);

package body Nomo.Interpreter.Plant.Targets is

   Duration_Limit : constant Positive_Time := Positive_Time (Reader.Parameters.Get_Time_Span_Limit);

   function Is_Expired (This : in Target;
                        T    : in Positive_Time) return Boolean is
   begin
      return T - This.Arrival_Time > Duration_Limit and then (This.Arrival_Time /= 0);
   end Is_Expired;

end Nomo.Interpreter.Plant.Targets;
