--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Reals.Long;

with Nomo.Numerics.Reals.Elementary_Functions;

with Nomo.Numerics.Accurately.Constants;

package body Nomo.Gen_External_Messages.Premises.Loading is

   procedure Set_Component (This        : in out External_Premise;
                            I           : in Component_Index;
                            Information : in Real;
                            Tolerance   : in Strictly_Positive_Real;
                            Fitting_Nbr : in Count) is
      use Numerics.Reals.Elementary_Functions;
      use Numerics.Accurately.Constants;
      use Numerics.Reals.Long;
   begin
      This.Information (I) := Information;
      This.Tolerance (I) := Tolerance;
      pragma Assert (I = Component_Index'Succ(This.Size) or else This.Size = Component_Index'First );
      This.Size := I;
      if Tolerance = Zero_Plus then
         This.Specificity_Log := This.Specificity_Log + Zero_Plus_Log;
      elsif Tolerance = Positive_Infinity then
         This.Specificity_Log := This.Specificity_Log + Positive_Infinity_Log;
      else
         This.Trend (I).Values_Sum :=  Long_Real (Information * Real (Fitting_Nbr));
         This.Trend (I).Squares_Sum :=  Long_Real ((Information**2 + Tolerance) * Real (Fitting_Nbr));
         This.Specificity_Log := This.Specificity_Log + Log_10 (Tolerance / 2.0);
      end if;
   end Set_Component;

end Nomo.Gen_External_Messages.Premises.Loading;
