--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Rules_Base.Spontaneous.Initialization;

with Nomo.Interpreter.External_Messages.Conclusions;

with Nomo.Interpreter.Storages.Reading;

with Nomo.Interpreter.Standard_Conditions.Initialization;

with Nomo.Interpreter.Perception_Rules.Feedback;

with Nomo.Interpreter.Types_Directory.Relations;

package body Nomo.Interpreter.Command_Rules.Initialization is

   function Get_Perception_Information (This : in Command_Rule) return Positive_Integer is
   begin
      return This.Internal_Conclusion.Get_Information;
   end Get_Perception_Information;

   procedure Initialize (This                       : out Command_Rule;
                         Rule_Storage               : in Full_Rule_Storage;
                         Matchmaker_Ptr             : not null access Internal_Events_Index.Matchmakers.Matchmaker;
                         Excitatory_Specificity_Log : out Real_Accurately;
                         Inhibitory_Specificity_Log : out Real_Accurately) is
      use Storages.Reading;
      use Rules_Base.Spontaneous.Initialization;
      use Internal_Messages.Conclusions.Instantaneous.Initialization;
      use External_Messages.Conclusions.Initialization;
      use Standard_Conditions.Initialization;
      use Types_Directory.Relations;
   begin
      Initialize (Spontaneous_Rule (This), Rule_Storage);
      Initialize (This.Internal_Conclusion,
                  Get_Internal_Conclusion (Rule_Storage).all);
      Set_External_Conclusion (This.External_Conclusion,
                               Get_External_Conclusion (Rule_Storage).all,
                               Get_Data_Size (Get_Conclusion_Type(Rule_Storage)));
      Initialize (This.Condition,
                  Get_Internal_Condition (Rule_Storage).all,
                  Get_Internal_Condition_Types (Rule_Storage).all,
                  Get_Internal_Condition_Properties (Rule_Storage).all,
                  Get_Internal_Premises_Number (Rule_Storage),
                  Get_Fitting_Nbr (Rule_Storage),
                  Matchmaker_Ptr,
                  Excitatory_Specificity_Log,
                  Inhibitory_Specificity_Log);
   end Initialize;

   package body Initial is
      procedure Set_Linked_Perception (This              : out Command_Rule;
                                       Linked_Perception : access Perception_Rules.Perception_Rule) is
         use Perception_Rules.Feedback;
      begin
         if Linked_Perception /= null then
            This.Linked_Perception := Linked_Perception;
            Get_Feedback (This.Linked_Perception, This.External_Conclusion'Unchecked_Access);
            This.Is_Upgradable := True;
         end if;
      end Set_Linked_Perception;
   end Initial;

   package body Inline is
      procedure Set_Linked_Perception (This              : out Command_Rule;
                                       Linked_Perception : not null access Perception_Rules.Perception_Rule) is
         use Perception_Rules.Feedback;
      begin
         This.Linked_Perception := Linked_Perception;
         Get_Feedback (This.Linked_Perception, This.External_Conclusion'Unchecked_Access);
         This.Is_Upgradable := True;
      end Set_Linked_Perception;
   end Inline;

end Nomo.Interpreter.Command_Rules.Initialization;
