--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Times;

with Nomo.Numerics.Accurately;

private with Nomo.Interpreter.Types_Index.Ranges;

private with Nomo.Interpreter.Beginning.Parameters;
pragma Elaborate_All (Nomo.Interpreter.Beginning.Parameters);

private with Nomo.Interpreter.Activations_Memories;
pragma Elaborate_All (Nomo.Interpreter.Activations_Memories);

private with Nomo.Interpreter.Gen_Clusters_Base;
pragma Elaborate_All (Nomo.Interpreter.Gen_Clusters_Base);

private with Nomo.Interpreter.Conception_Rules;

private package Nomo.Interpreter.Conceptions_Clusters is

   use Numerics.Times;
   use Numerics.Accurately;

   type Conceptions_Cluster is tagged limited private;

   procedure Assume (This : in out Conceptions_Cluster;
                     T    : in Positive_Time);

   function Has_Selection (This : in Conceptions_Cluster) return Boolean;
   pragma Inline (Has_Selection);

   procedure Interpret (This : in out Conceptions_Cluster);
   pragma Inline (Interpret);

   procedure Reinforce (This            : in out Conceptions_Cluster;
                        T               : in Positive_Time;
                        First_Landmark  : in Positive_Time_Interval;
                        Second_Landmark : in Positive_Time_Interval;
                        Quantity        : in Real_Accurately_0_To_1);
   pragma Inline (Reinforce);

private

   use Types_Index.Ranges;
   use Conception_Rules;

   type Conceptive_Rule_Ptr is access all Conception_Rule;

   package Conceptions_Clusters_Base is new Gen_Clusters_Base (Conception_Rule,
                                                               Conceptive_Rule_Ptr,
                                                               Beginning.Parameters.Get_Maximum_Of_Rules_By_Type,
                                                               Adjust,
                                                               Evaluate,
                                                               Evaluate,
                                                               Is_Forget,
                                                               Is_Updatable,
                                                               Update_Relevance,
                                                               Update_Relevance);
   use Conceptions_Clusters_Base;

   package Activations_Conceptions_Memories is new Activations_Memories (Conception_Rule,
                                                                         Conceptive_Rule_Ptr,
                                                                         Reinforce);
   use Activations_Conceptions_Memories;

   type Conceptions_Cluster is new Cluster_Base with record
      Activations     : Activations_Memory;
      Conception_Type : Conception_Type_Index;
   end record;

end Nomo.Interpreter.Conceptions_Clusters;
