--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Informations;

with Nomo.Interpreter.Storages;

with Nomo.Internal_Messages.Conclusions.Delayed.Predictive;

limited with Nomo.Interpreter.Internal_Events_Index.Matchmakers;

package Nomo.Interpreter.Prediction_Rules.Initialization is

   use Internal_Messages.Conclusions.Delayed.Predictive.Pointer;

   procedure Get_Conclusion (This       : in out Prediction_Rule;
                             Conclusion : out Predictive_Conclusion_Ptr);

   use Numerics.Informations;

   function Is_Equal (This        : in Prediction_Rule;
                      Information : in Positive_Integer) return Boolean;

   use Storages;

   procedure Initialize (This                       : out Prediction_Rule;
                         Rule_Storage               : in Full_Rule_Storage;
                         Matchmaker_Ptr             : not null access Internal_Events_Index.Matchmakers.Matchmaker;
                         Excitatory_Specificity_Log : out Real_Accurately;
                         Inhibitory_Specificity_Log : out Real_Accurately);

end Nomo.Interpreter.Prediction_Rules.Initialization;
