--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Reals.Long;

with Nomo.Numerics.Times;

package Nomo.Integrations is

   pragma Pure;

   use Numerics.Reals.Long;

   type Real_Integration is record
      Values_Sum   : Long_Real := 0.0;
      Squares_Sum  : Long_Real range 0.0 .. Long_Real'Last := 0.0;
   end record;

   use Numerics.Times;

   type Time_Integration is record
      Values_Sum   : Time := 0;
      Squares_Sum  : Positive_Time := 0;
   end record;

end Nomo.Integrations;
