--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

package body Nomo.Internal_Messages.Events is

   function Is_Equal (This   : in Internal_Message;
                      Target : in Internal_Message) return Boolean is
   begin
      return Target.Information = This.Information;
   end Is_Equal;

   procedure Reset_Time_Span (This : in out Internal_Message) is
   begin
      This.Time_Span := 0;
   end Reset_Time_Span;

   procedure Set (This    : out Internal_Message;
                  Content : in Internal_Message) is
   begin
      --  Ici, il n'y a pas besoin d'affecter "This.Time_Span" puisque
      --  cette tiquette temporelle aura t recalcule avant toute utilisation
      --  par "Update_Time_Span" ou "Reset_Time_Span".
      This.Credibility := Content.Credibility;
      This.Information := Content.Information;
   end Set;

   procedure Update_Time_Span (This      : in out Internal_Message;
                               Time_Span : in Time_Interval) is
   begin
      This.Time_Span := Time_Span;
   end Update_Time_Span;

end Nomo.Internal_Messages.Events;
