--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Times;

with Nomo.Numerics.Reals;

with Nomo.Interpreter.Premises_Index;

private package Nomo.Interpreter.Actuators_Buffers is

   use Numerics.Times;
   use Numerics.Reals;
   use Premises_Index.Premises_Index_Instance;

   type actuator_buffer is record
      Time_Span   : Time_Interval;
      Credibility : Real_0_To_1;
   end record;

   type Actuators_Buffer is array (Premise_Index'Range) of actuator_buffer;

end Nomo.Interpreter.Actuators_Buffers;
