--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Storages;
use Nomo.Interpreter.Storages;

private with Nomo.Interpreter.Gen_Rules_Directories.Insertion;
pragma Elaborate_All (Nomo.Interpreter.Gen_Rules_Directories.Insertion);

generic
   with procedure Initialize (This                       : out Rule;
                              Rule_Storage               : Full_Rule_Storage;
                              Matchmaker_Ptr             : not null access Internal_Events_Index.Matchmakers.Matchmaker;
                              Excitatory_Specificity_Log : out Real_Accurately;
                              Inhibitory_Specificity_Log : out Real_Accurately);
package Nomo.Interpreter.Gen_Clusters_Base.Standard_Loading is

   function Has_Space (This : in Cluster_Base) return Boolean;

   procedure Load (This             : in out Cluster_Base;
                   Rule_Storage_Ptr : not null access constant Full_Rule_Storage);
private

   package Local_Insertion is new Local_Rules_Directories.Insertion (Is_Updatable);

end Nomo.Interpreter.Gen_Clusters_Base.Standard_Loading;
