--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Times;

with Nomo.Numerics.Accurately;

private with Nomo.Interpreter.Beginning.Parameters;
pragma Elaborate_All (Nomo.Interpreter.Beginning.Parameters);

private with Nomo.Interpreter.Gen_Clusters_Base;
pragma Elaborate_All (Nomo.Interpreter.Gen_Clusters_Base);

private with Nomo.Interpreter.Reward_Rules;

private with Nomo.Interpreter.Types_Index.Ranges;

private with Nomo.Interpreter.Targets_Rewards;

private package Nomo.Interpreter.Rewards_Clusters is

   use Numerics.Times;
   use Numerics.Accurately;

   type Rewards_Cluster is tagged limited private;

   procedure Assume (This : in out Rewards_Cluster;
                     T    : in Positive_Time);

   function Has_Selection (This : in Rewards_Cluster) return Boolean;
   pragma Inline (Has_Selection);

   procedure Interpret (This : in out Rewards_Cluster);
   pragma Inline (Interpret);

   procedure Reinforce (This            : in out Rewards_Cluster;
                        T               : in Positive_Time;
                        First_Landmark  : in Positive_Time_Interval;
                        Second_Landmark : in Positive_Time_Interval;
                        Quantity        : in Real_Accurately_0_To_1) is null;

private

   use Types_Index.Ranges;
   use Reward_Rules;

   type Rewarding_Rule_Ptr is access all Reward_Rule;

   package Rewards_Clusters_Base is new Gen_Clusters_Base (Reward_Rule,
                                                           Rewarding_Rule_Ptr,
                                                           Beginning.Parameters.Get_Maximum_Of_Rules_By_Type,
                                                           Adjust,
                                                           Evaluate,
                                                           Evaluate,
                                                           Is_Forget,
                                                           Is_Updatable,
                                                           Update_Relevance,
                                                           Update_Relevance);
   use Rewards_Clusters_Base;
   use Targets_Rewards;

   type Rewards_Cluster is new Cluster_Base with record
      Reward_Type : Reward_Type_Index;
      Targets     : aliased Targets_Reward;
   end record;

end Nomo.Interpreter.Rewards_Clusters;
