--  Copyright (2008) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

package Standard_Random is

   --  Random Generator standard Minimal of Park & Miller

   function Random return Positive;
   --  Renvoie A = (16807 * A) mod (Rand_Max+1)

   procedure Reset;
   --  Remet A  la dernire valeur initiale, par dfaut 12346789

   procedure Reset (Initiator : in Positive);
   --  A = Initiator

   Rand_Max : constant Positive;

   function Random_Gaussian (Average : in Float;
                             Sigma   : in Float) return Float;

private

   Rand_Max : constant Positive := 2**31 - 2;

end Standard_Random;
