<?xml version="1.0" encoding="utf-8" standalone="yes"?>
<!--
  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program. If not, see <http://www.gnu.org/licenses/>
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sdk="http://www.nomoseed.org/nomosdk" xmlns="http://www.w3.org/2001/XMLSchema">
	<xsl:output method="xml" indent="yes" encoding="utf-8"/>
	<xsl:template match="/sdk:formalisms">
		<xsl:element name="schema" namespace="http://www.w3.org/2001/XMLSchema">
			<xsl:attribute name="elementFormDefault">
				<xsl:value-of select="'qualified'"/>
			</xsl:attribute>
			<xsl:attribute name="attributeFormDefault">
				<xsl:value-of select="'unqualified'"/>
			</xsl:attribute>
			<xsl:attribute name="targetNamespace">
				<xsl:value-of select="'http://www.nomoseed.org/sdk'"/>
			</xsl:attribute>
			<xsl:for-each select="/sdk:formalisms/sdk:formalism">
				<import namespace="http://www.nomoseed.org/{@name}" schemaLocation="../formalisms/{@name}/{@name}.xsd"/>
			</xsl:for-each>
			<annotation>
				<documentation xml:lang="en">Copyright © 2013 Cédric Coussinet. All rights reserved.</documentation>
			</annotation>
			<complexType name="formalism" abstract="true"/>
			<xsl:for-each select="/sdk:formalisms/sdk:formalism">
				<complexType name="{@name}">
					<complexContent>
						<extension base="sdk:formalism" xmlns:sdk="http://www.nomoseed.org/sdk">
							<sequence>
								<xsl:element name="element" namespace="http://www.w3.org/2001/XMLSchema">
									<xsl:attribute name="ref">
										<xsl:value-of select="concat(@name,':',@name)"/>
									</xsl:attribute>
									<xsl:attribute name="{concat(@name,':formalism')}" namespace="{concat('http://www.nomoseed.org/',@name)}">
										<xsl:value-of select="concat('http://www.nomoseed.org/',@name)"/>
									</xsl:attribute>
									<xsl:attribute name="minOccurs">
										<xsl:value-of select="1"/>
									</xsl:attribute>
									<xsl:attribute name="maxOccurs">
										<xsl:value-of select="1"/>
									</xsl:attribute>
								</xsl:element>
							</sequence>
						</extension>
					</complexContent>
				</complexType>
			</xsl:for-each>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>
