<?xml version="1.0" encoding="utf-8" ?>
<!--
  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program. If not, see <http://www.gnu.org/licenses/>
-->

<!--
	Adapte le modèle définissant les resgistres utilisés pour la création de règle.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:program="http://www.nomoseed.org/program" xmlns:model="http://www.nomoseed.org/model" xmlns:project="http://www.nomoseed.org/project">
	<xsl:template name="create_plant">
		<xsl:param name="others_registers_nbr"/>
    <inherite instance="plant" prototype="plant" model="plant" xmlns="http://www.nomoseed.org/program">
      <plant_structure name="plant" extension="true" xmlns="http://www.nomoseed.org/plant">
        <definition model="plant">
          <transition_type name="transition">
            <declaration model="plant" type="transition" category="transition" />
            <items>
              <item name="begin_affectation" model="plant"/>
              <item name="begin_inhibition" model="plant"/>
              <item name="begin_excitation" model="plant"/>
              <item name="begin_finalization" model="plant"/>
            </items>
          </transition_type>
          <anomaly_type name="anomaly">
            <declaration model="plant" type="anomaly" category="anomaly"/>
            <items>
              <item name="affectation_expired_for_reference_time" model="plant"/>
              <item name="affectation_expired_for_shifting_time" model="plant"/>
              <item name="affectation_expired_operator_for_target" model="plant"/>
              <item name="already_affected_chunk" model="plant"/>
              <item name="already_created_perception" model="plant"/>
              <item name="already_designed_reference_time" model="plant"/>
              <item name="already_designed_target" model="plant"/>
              <item name="bad_reference_time" model="plant"/>
              <item name="expired_external_chunck" model="plant"/>
              <item name="expired_internal_chunck" model="plant"/>
              <item name="expired_internal_target" model="plant"/>
              <item name="fail_chunck_inactive" model="plant"/>
              <item name="fail_landmark_id" model="plant"/>
              <item name="fail_landmark_type" model="plant"/>
              <item name="fail_linked_perception" model="plant"/>
              <item name="fail_perception_of_command_conclusion" model="plant"/>
              <item name="fail_prediction_id_in_checking_rule" model="plant"/>
              <item name="fail_predictive_type_in_checking_rule" model="plant"/>
              <item name="fail_search_event" model="plant"/>
              <item name="fail_targeted_affectation" model="plant"/>
              <item name="forbidden_reflection_return_in_conclusion" model="plant"/>
              <item name="illegal_creation_operator_in_external_chunk" model="plant"/>
              <item name="illegal_creation_operator_in_internal_chunk" model="plant"/>
              <item name="illegal_landmark_type" model="plant"/>
              <item name="illegal_operator_in_affectation" model="plant"/>
              <item name="illegal_operator_in_conclusion" model="plant"/>
              <item name="illegal_operator_in_condition" model="plant"/>
              <item name="illegal_reference_for_creation" model="plant"/>
              <item name="illegal_reference_for_input_condition" model="plant"/>
              <item name="illegal_reference_for_internal_conclusion" model="plant"/>
              <item name="illegal_reference_for_internal_condition" model="plant"/>
              <item name="illegal_reference_for_perception_conclusion" model="plant"/>
              <item name="illegal_start_in_affectation" model="plant"/>
              <item name="illegal_start_in_conclusion" model="plant"/>
              <item name="illegal_start_in_excitatory_premise" model="plant"/>
              <item name="illegal_start_in_inhibitory_premise" model="plant"/>
              <item name="illegal_start_in_standby" model="plant"/>
              <item name="illegal_target_in_external_chunk" model="plant"/>
              <item name="input_premise_in_inhibitory_premise" model="plant"/>
              <item name="input_premise_missing" model="plant"/>
              <item name="missing_landmark_rule" model="plant"/>
              <item name="missing_predictive_rule" model="plant"/>
              <item name="missing_target_for_affectation_operator" model="plant"/>
              <item name="no_unique_command_conclusion" model="plant"/>
              <item name="no_unique_perception_conclusion" model="plant"/>
              <item name="no_unique_prediction_conclusion" model="plant"/>
              <item name="over_affectation_operators_for_target" model="plant"/>
              <item name="over_input_premise" model="plant"/>
              <item name="over_internal_premises_number" model="plant"/>
              <item name="over_rules" model="plant"/>
              <item name="over_time_span_for_internal_condition" model="plant"/>
              <item name="same_time_condition_conclusion" model="plant"/>
            </items>
          </anomaly_type>
          <registers_structure>
            <input>
              <scope_type>
                <declaration model="plant" type="register_00" category="scope"/>
              </scope_type>
              <operator_type>
                <declaration model="plant" type="register_00" category="operator"/>
                <items>
                  <item name="get_after" model="plant"/>
                  <item name="get_before" model="plant"/>
                  <item name="get_first" model="plant"/>
                  <item name="get_last" model="plant"/>
                  <item name="get_same" model="plant"/>
                  <item name="get_there" model="plant"/>
                </items>
              </operator_type>
            </input>
            <other>
              <scope_type>
                <declarations>
                  <xsl:call-template name="create_declaration">
                    <xsl:with-param name="i" select="$others_registers_nbr"/>
                    <xsl:with-param name="category" select="'scope'"/>
                  </xsl:call-template>
                </declarations>
              </scope_type>
              <operator_type>
                <declarations>
                  <xsl:call-template name="create_declaration">
                    <xsl:with-param name="i" select="$others_registers_nbr"/>
                    <xsl:with-param name="category" select="'operator'"/>
                  </xsl:call-template>
                </declarations>
                <items>
                  <item name="get_after" model="plant"/>
                  <item name="get_before" model="plant" />
                  <item name="get_first" model="plant" />
                  <item name="get_last" model="plant" />
                  <item name="get_same" model="plant"/>
                  <item name="get_there" model="plant" />
                  <item name="copy" model="plant" />
                  <item name="create_check_forward" model="plant" />
                  <item name="create_command" model="plant" />
                  <item name="create_conception" model="plant" />
                  <item name="create_landmark" model="plant" />
                  <item name="create_perception_forward" model="plant" />
                  <item name="create_prediction" model="plant" />
                  <item name="create_reward" model="plant" />
                  <item name="create_twin" model="plant" />
                  <item name="target" model="plant" />
                  <item name="transform_in_temporal_reference" model="plant" />
                  <item name="transform_in_temporal_reference_and_origin" model="plant" />
                  <item name="forward" model="plant" />
                  <item name="backward" model="plant" />
                  <item name="same_time" model="plant" />
                </items>
              </operator_type>
            </other>
          </registers_structure>
        </definition>
      </plant_structure>
    </inherite>
    </xsl:template>
    <xsl:template name="create_declaration">
      <xsl:param name="i"/>
      <xsl:param name="category"/>
      <xsl:if test="$i &gt; 1">
        <xsl:call-template name="create_declaration">
          <xsl:with-param name="i" select="$i - 1"/>
          <xsl:with-param name="category" select="$category"/>
        </xsl:call-template>
      </xsl:if>
      <xsl:element name="declaration" namespace="http://www.nomoseed.org/plant">
        <xsl:attribute name="category">
          <xsl:value-of select="$category"/>
        </xsl:attribute>
        <xsl:attribute name="model">
          <xsl:value-of select="'plant'"/>
        </xsl:attribute>
        <xsl:attribute name="type">
          <xsl:choose>
            <xsl:when test="$i &gt; 9">
              <xsl:value-of select="concat('register_',$i)"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="concat('register_0',$i)"/>
            </xsl:otherwise>
          </xsl:choose>
			</xsl:attribute>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>
