--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

package body Nomo.Interpreter.Check_Rules is

   procedure Add_Score (This : in out Check_Rule) is
      Is_Noteworthy : Boolean;
   begin
      Rules_Base.Delayed.Add_Score (Delayed_Rule (This), This.Condition.Get_Score, Is_Noteworthy);
      if Is_Noteworthy then
         This.Condition.Note;
         This.Credibility_Max := This.Condition.Get_Credibility;
      end if;
   end Add_Score;

   procedure Adjust (This : in out Check_Rule) is
      Is_Maximizable : Boolean;
   begin
      This.Conclusion.Set_Credibility (This.Credibility_Max);
      Rules_Base.Delayed.Adjust (Delayed_Rule (This), Is_Maximizable);
      if Is_Maximizable then
         if This.Condition.Is_Optimizable then
            This.Condition.Maximize;
            This.Linked_Prediction.all.Adjust_Prediction (This.Condition.Get_New_Time_Span, This.Condition.Get_New_Bonus);
         end if;
         This.Credibility_Max := 0.0;
         Rules_Base.Delayed.Reset (Delayed_Rule (This));
      end if;
   end Adjust;

   function Are_Eligible (Precitive_Link : in Prediction_Type_Index) return Boolean renames Check_Conditions.Are_Possibly_Ongoing;

   procedure Evaluate (This : in out Check_Rule) is
   begin
      This.Condition.Evaluate;
   end Evaluate;

   function Get_Conclusion (This : in Check_Rule) return not null access constant Internal_Messages.Internal_Message is
   begin
      return Internal_Messages.Internal_Message (This.Conclusion)'Unchecked_Access;
   end Get_Conclusion;

   function Is_Ongoing (This : in Check_Rule) return Boolean is
   begin
      return This.Condition.Is_Ongoing;
   end Is_Ongoing;

   function Is_Forget (This : in Check_Rule) return Boolean is
      use Rules_Base;
   begin
      return Is_Forget (Rule_Base (This));
   end Is_Forget;

   function Is_Updatable (This : in Check_Rule) return Boolean is
      use Rules_Base;
   begin
      return Is_Updatable (Rule_Base (This));
   end Is_Updatable;

   procedure Update_Relevance (This : in out Check_Rule) is
   begin
      Rules_Base.Delayed.Update_Relevance (Delayed_Rule (This));
   end Update_Relevance;

end Nomo.Interpreter.Check_Rules;
