--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Times;

with Nomo.Internal_Messages;

with Nomo.Interpreter.Types_Index.Ranges;

with Nomo.Interpreter.Internal_Events_Index;

package Nomo.Interpreter.Event_Memory.Internal.Plant is

   use Numerics.Times;
   use Internal_Messages;
   use Types_Index.Ranges;
   use Internal_Events_Index;

   function Get_Before_Arrival_Time (I        : in Internal_Type_Index;
                                     Position : in Internal_Event_Index) return Positive_Time;
   pragma Inline (Get_Before_Arrival_Time);

   function Get_First_Arrival_Time (I        : in Internal_Type_Index;
                                    Position : in Internal_Event_Index) return Positive_Time;
   pragma Inline (Get_First_Arrival_Time);

   function Get_Last_Arrival_Time (I        : in Internal_Type_Index;
                                   Position : in Internal_Event_Index) return Positive_Time;
   pragma Inline (Get_Last_Arrival_Time);

   function Get_After_Arrival_Time (I        : in Internal_Type_Index;
                                    Position : in Internal_Event_Index) return Positive_Time;
   pragma Inline (Get_After_Arrival_Time);

   function Get_Same_Arrival_Time (I        : in Internal_Type_Index;
                                   Position : in Internal_Event_Index) return Positive_Time;
   pragma Inline (Get_Same_Arrival_Time);

   function Get_Before_Position (I        : in Internal_Type_Index;
                                 Position : in Internal_Event_Index) return Internal_Event_Index;
   pragma Inline (Get_Before_Position);

   function Get_First_Position (I        : in Internal_Type_Index;
                                Position : in Internal_Event_Index) return Internal_Event_Index;
   pragma Inline (Get_First_Position);

   function Get_Last_Position (I        : in Internal_Type_Index;
                               Position : in Internal_Event_Index) return Internal_Event_Index;
   pragma Inline (Get_Last_Position);

   function Get_After_Position (I        : in Internal_Type_Index;
                                Position : in Internal_Event_Index) return Internal_Event_Index;
   pragma Inline (Get_After_Position);

   function Get_Same_Position (I        : in Internal_Type_Index;
                               Position : in Internal_Event_Index) return Internal_Event_Index;
   pragma Inline (Get_Same_Position);

   procedure Get_Current_Event (Scope_Index  : in Positive;
                                I            : out Internal_Type_Index;
                                Position     : out Internal_Event_Index;
                                Arrival_Time : out Positive_Time);
   pragma Inline (Get_Current_Event);

   procedure Get_Event (I             : in Internal_Type_Index;
                        Arrival_Time  : in out Positive_Time;
                        Internal_Data : out Internal_Message);
   pragma Inline (Get_Event);

   procedure Get_Event (I             : in Internal_Type_Index;
                        Position      : in Internal_Event_Index;
                        Internal_Data : out Internal_Message);
   pragma Inline (Get_Event);

   procedure Get_Event (I             : in Internal_Type_Index;
                        Position      : in Internal_Event_Index;
                        Arrival_Time  : out Positive_Time;
                        Internal_Data : out Internal_Message);
   pragma Inline (Get_Event);

end Nomo.Interpreter.Event_Memory.Internal.Plant;
