--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>
--  La primitive cognitive cre de nouvelles rgles qui ont t dcrites
--   l'aide des messages reus (cf. Tutoriel).

with Nomo.Numerics.Times;

with Nomo.Numerics.Informations;

with Nomo.Interpreter.Plant.Chunks_Index;

package Nomo.Interpreter.Plant.Engine is

   use Numerics.Times;
   use Numerics.Informations;
   use Chunks_Index;

   procedure Assume (T : in Positive_Time);

   protected Put is
      procedure Operator (Index       : in Chunk_Index;
                          Information : in Positive_Integer);

      procedure Pointer (Index        : in Chunk_Index;
                         Information  : in Positive_Integer);

      procedure Transition (Information : in Positive_Integer);
   end Put;

end Nomo.Interpreter.Plant.Engine;
