--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Reals;

with Nomo.Numerics.Accurately;

with Nomo.Numerics.Fitting;

with Nomo.Interpreter.External_Messages.Premises;

with Nomo.Internal_Messages.Premises;

with Nomo.Premise_Properties;

with Nomo.Interpreter.Types_Index.Ranges;

with Nomo.Interpreter.Premises_Index;

with Nomo.Interpreter.Components_Index;

package Nomo.Interpreter.Storages.Writing is

   use Types_Index.Ranges;

   procedure Set_Conclusion_Type (This          : out Full_Rule_Storage;
                                  Internal_Type : in Internal_Type_Index);
   pragma Precondition (not (Internal_Type in Anomaly_Type_Index));

   procedure Set_Id (This : out Full_Rule_Storage;
                     Id   : in Positive);

   use Internal_Messages;

   procedure Set_Internal_Conclusion (This                : out Full_Rule_Storage;
                                      Internal_Conclusion : in Internal_Message);

   use Internal_Messages.Premises;
   use Premises_Index.Premises_Index_Instance;

   procedure Set_Internal_Premise (This          : out Full_Rule_Storage;
                                   I             : in Premise_Index;
                                   Premise       : in Internal_Premise;
                                   Internal_Type : in Internal_Type_Index);
   pragma Precondition (I > 0);

   use Premise_Properties;

   procedure Set_Condition_Property (This     : out Full_Rule_Storage;
                                     I        : in Premise_Index;
                                     Property : in Premise_Property);

   procedure Set_Internal_Premises_Number (This            : out Full_Rule_Storage;
                                           Premises_Number : in Premise_Index);

   use Numerics.Fitting;

   procedure Set_Fitting_Nbr (This        : out Full_Rule_Storage;
                              Fitting_Nbr : in Count);

   use Numerics.Accurately;

   procedure Set_Relevance (This      : out Full_Rule_Storage;
                            Relevance : in Real_Accurately_0_To_1);

   use Numerics.Reals;

   procedure Set_Credibility (This        : out Full_Rule_Storage;
                              Credibility : in Real_0_To_1);

   use External_Messages;

   procedure Set_External_Conclusion (This                : in out Full_Rule_Storage;
                                      External_Conclusion : in External_Message);

   use Components_Index.Components_Index_Instance;

   procedure Set_External_Conclusion_Size (This : out Full_Rule_Storage;
                                           Size : in Component_Index);

   use External_Messages.Premises;

   procedure Set_External_Condition (This               : out Full_Rule_Storage;
                                     External_Condition : in External_Premise;
                                     Internal_Type      : in External_Type_Index);

end Nomo.Interpreter.Storages.Writing;
