﻿//  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published
//  by the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program. If not, see <http://www.gnu.org/licenses/>

#include "xmlutil.h"
#include <string.h>

xmlNodePtr xmlGetNodeByName (const xmlNodePtr parent, const char* name) {
    xmlNodePtr n;
    for (n=parent->last;n;n=n->prev)
        if((n->type != XML_CDATA_SECTION_NODE) && (n->type != XML_TEXT_NODE))
            if (!strcmp((const char*)n->name, name))
                return n;
    return NULL;
}

xmlNodePtr xmlGetNodeById (const xmlNodePtr parent, const char* name, const char* id) {
    xmlNodePtr n;
    for (n=parent->last;n;n=n->prev)
        if((n->type != XML_CDATA_SECTION_NODE) && (n->type != XML_TEXT_NODE))
            if (!strcmp((const char*)n->name, name))
                if (!strcmp((const char*)xmlGetProp(n, (const xmlChar*) "id"), id))
                    return n;
    return NULL;
}

xmlNodePtr xmlGetNodeByAttribute (const xmlNodePtr parent, const char* name, const char* att, const char* value) {
    xmlNodePtr n;
    for (n=parent->last;n;n=n->prev)
        if((n->type != XML_CDATA_SECTION_NODE) && (n->type != XML_TEXT_NODE))
            if (!strcmp((const char*)n->name, name))
                if (!strcmp((const char*)xmlGetProp(n, (const xmlChar*)att), value))
                    return n;
    return NULL;
}
