--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

pragma Restrictions (Simple_Barriers);
pragma Restrictions (No_Abort_Statements);
pragma Restrictions (No_Asynchronous_Control);
pragma Restrictions (No_Default_Stream_Attributes);
pragma Restrictions (No_Dynamic_Attachment);
pragma Restrictions (No_Dynamic_Priorities);
pragma Restrictions (No_Entry_Calls_In_Elaboration_Code);
pragma Restrictions (No_Entry_Queue);
pragma Restrictions (No_Exception_Registration);
pragma Restrictions (No_Implicit_Heap_Allocations);
pragma Restrictions (No_Initialize_Scalars);
pragma Restrictions (No_Local_Timing_Events);
pragma Restrictions (No_Local_Protected_Objects);
pragma Restrictions (No_Protected_Type_Allocators);
pragma Restrictions (No_Protected_Types);
pragma Restrictions (No_Relative_Delay);
pragma Restrictions (No_Requeue_Statements);
pragma Restrictions (No_Select_Statements);
pragma Restrictions (No_Specific_Termination_Handlers);
pragma Restrictions (No_Stream_Optimizations);
pragma Restrictions (No_Task_Allocators);
pragma Restrictions (No_Task_Attributes_Package);
pragma Restrictions (No_Task_Hierarchy);
pragma Restrictions (No_Task_Termination);
pragma Restrictions (No_Tasking);
pragma Restrictions (No_Terminate_Alternatives);
pragma Restrictions (Static_Priorities);
pragma Restrictions (Static_Storage_Size);
pragma Restrictions (Immediate_Reclamation);
pragma Restrictions (No_Wide_Characters);
pragma Restrictions (No_Implementation_Restrictions);
pragma Restrictions (Max_Protected_Entries => 0);
pragma Restrictions (Max_Select_Alternatives => 0);
pragma Restrictions (Max_Task_Entries => 0);
pragma Restrictions (Max_Tasks => 0);
pragma Restrictions (Max_Asynchronous_Select_Nesting => 0);

with Interfaces.C.Strings;

package Nomotools is

   procedure Compile (Code_Path : in Interfaces.C.Strings.chars_ptr;
                      Length    : in Interfaces.C.size_t);
   pragma Export (Convention => C, Entity => Compile, External_Name => "compile");

   procedure FR_To_Seed (Log_Path         : in Interfaces.C.Strings.chars_ptr;
                         Log_Path_Length  : in Interfaces.C.size_t;
                         Seed_Path        : in Interfaces.C.Strings.chars_ptr;
                         Seed_Path_Length : in Interfaces.C.size_t;
                         Crush            : in Interfaces.C.short);
   pragma Export (Convention => C, Entity => FR_To_Seed, External_Name => "fr_to_seed");

   procedure PR_To_CSV (Log_Path : in Interfaces.C.Strings.chars_ptr;
                        Length   : in Interfaces.C.size_t);
   pragma Export (Convention => C, Entity => PR_To_CSV, External_Name => "pr_to_csv");

   procedure FR_To_CSV (Log_Path : in Interfaces.C.Strings.chars_ptr;
                        Length   : in Interfaces.C.size_t);
   pragma Export (Convention => C, Entity => FR_To_CSV, External_Name => "fr_to_csv");

   procedure PR_To_XML (Log_Path : in Interfaces.C.Strings.chars_ptr;
                        Length   : in Interfaces.C.size_t);
   pragma Export (Convention => C, Entity => PR_To_XML, External_Name => "pr_to_xml");

   procedure FR_To_XML (Log_Path : in Interfaces.C.Strings.chars_ptr;
                        Length   : in Interfaces.C.size_t);
   pragma Export (Convention => C, Entity => FR_To_XML, External_Name => "fr_to_xml");

   procedure PR_To_DB (Log_Path   : in Interfaces.C.Strings.chars_ptr;
                       Log_Length : in Interfaces.C.size_t;
                       DB_Path    : in Interfaces.C.Strings.chars_ptr;
                       DB_Length  : in Interfaces.C.size_t;
                       Create     : in Interfaces.C.int);
   pragma Export (Convention => C, Entity => PR_To_DB, External_Name => "pr_to_db");

   procedure FR_To_DB (Log_Path   : in Interfaces.C.Strings.chars_ptr;
                       Log_Length : in Interfaces.C.size_t;
                       DB_Path    : in Interfaces.C.Strings.chars_ptr;
                       DB_Length  : in Interfaces.C.size_t;
                       Create     : in Interfaces.C.int);
   pragma Export (Convention => C, Entity => FR_To_DB, External_Name => "fr_to_db");

end Nomotools;
