//  Copyright (2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published
//  by the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program. If not, see <http://www.gnu.org/licenses/>

#ifndef NOMOTOOLS_H
#define NOMOTOOLS_H

extern "C" {
    void nomotoolsinit (void);
    void compile (const char * codePath, size_t len);
    void fr_to_seed (const char * logPath, const size_t lenLogPath, const char * seedPath, const size_t lenSeedPath, const short crush);
    void pr_to_csv (const char * logPath, const size_t len);
    void fr_to_csv (const char * logPath, const size_t len);
    void pr_to_xml (const char * logPath, const size_t len);
    void fr_to_xml (const char * logPath, const size_t len);
    void pr_to_db (const char * logPath, const size_t logLen, const char * dbPath, const size_t dbLen, const int create);
    void fr_to_db (const char * logPath, const size_t logLen, const char * dbPath, const size_t dbLen, const int create);
    void nomotoolsfinal (void);
}

#endif // NOMOTOOLS_H
