--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Times;

with Nomo.Numerics.Reals;

generic
   Check_Cover : Positive_Real;
package Nomo.Internal_Messages.Premises.Gen_Checking is

   pragma Pure;

   use Numerics.Times;
   use Numerics.Reals;

   procedure Get_Actuator (This        : in Internal_Premise;
                           Time_Span   : out Time_Interval;
                           Credibility : out Real_0_To_1);

   procedure Get_New_Time_Span (Landmark  : in Internal_Premise;
                                Time_Span : out Positive_Time_Interval;
                                Bonus     : out Positive_Time_Interval);
   pragma Inline (Get_New_Time_Span);

   procedure Maximize_Landmark(This        : in out Internal_Premise;
                               Fitting_Nbr : in Count);

   procedure Set_Actuator (This        : out Internal_Premise;
                           Time_Span   : in Time_Interval;
                           Credibility : in Real_0_To_1);

end Nomo.Internal_Messages.Premises.Gen_Checking;
