--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Epistemic_Memory.Checking.Loading;
pragma Elaborate_All (Nomo.Interpreter.Epistemic_Memory.Checking.Loading);

with Nomo.Interpreter.Epistemic_Memory.Conceptive.Loading;
pragma Elaborate_All (Nomo.Interpreter.Epistemic_Memory.Conceptive.Loading);

with Nomo.Interpreter.Epistemic_Memory.Landmarking.Loading;
pragma Elaborate_All (Nomo.Interpreter.Epistemic_Memory.Landmarking.Loading);

with Nomo.Interpreter.Epistemic_Memory.Commanding.Loading;
pragma Elaborate_All (Nomo.Interpreter.Epistemic_Memory.Commanding.Loading);

with Nomo.Interpreter.Epistemic_Memory.Perceptive.Loading;
pragma Elaborate_All (Nomo.Interpreter.Epistemic_Memory.Perceptive.Loading);

with Nomo.Interpreter.Epistemic_Memory.Predictive.Loading;
pragma Elaborate_All (Nomo.Interpreter.Epistemic_Memory.Predictive.Loading);

with Nomo.Interpreter.Epistemic_Memory.Reflective.Loading;
pragma Elaborate_All (Nomo.Interpreter.Epistemic_Memory.Reflective.Loading);

with Nomo.Interpreter.Epistemic_Memory.Rewarding.Loading;
pragma Elaborate_All (Nomo.Interpreter.Epistemic_Memory.Rewarding.Loading);

package body Nomo.Interpreter.Epistemic_Memory.Loading is

   function Has_Space (I : in Internal_Type_Index) return Boolean is
      Result : Boolean := False;
   begin
      if I in Check_Type_Index'Range then
         Result := Epistemic_Memory.Checking.Loading.Has_Space (I);
      elsif I in Conception_Type_Index'Range then
         Result := Epistemic_Memory.Conceptive.Loading.Has_Space (I);
      elsif I in Landmark_Type_Index'Range then
         Result := Epistemic_Memory.Landmarking.Loading.Has_Space (I);
      elsif I in Command_Type_Index'Range then
         Result := Epistemic_Memory.Commanding.Loading.Has_Space (I);
      elsif I in Perception_Type_Index'Range then
         Result := Epistemic_Memory.Perceptive.Loading.Has_Space (I);
      elsif I in Prediction_Type_Index'Range then
         Result := Epistemic_Memory.Predictive.Loading.Has_Space (I);
      elsif I in Reflective_Type_Index'Range then
         Result := Epistemic_Memory.Reflective.Loading.Has_Space (I);
      elsif I in Reward_Type_Index'Range then
         Result := Epistemic_Memory.Rewarding.Loading.Has_Space (I);
      end if;
      return Result;
   end Has_Space;

   procedure Load (I                : in Internal_Type_Index;
                   Rule_Storage_Ptr : not null access constant Storages.Full_Rule_Storage) is
   begin
      if I in Check_Type_Index'Range then
         Epistemic_Memory.Checking.Loading.Load (I, Rule_Storage_Ptr);
         Epistemic_Memory.Checking.Loading.Update_Last_Link (I);
      elsif I in Conception_Type_Index'Range then
         Epistemic_Memory.Conceptive.Loading.Load (I, Rule_Storage_Ptr);
      elsif I in Landmark_Type_Index'Range then
         Epistemic_Memory.Landmarking.Loading.Load (I, Rule_Storage_Ptr);
      elsif I in Command_Type_Index'Range then
         Epistemic_Memory.Commanding.Loading.Load (I, Rule_Storage_Ptr);
         Epistemic_Memory.Commanding.Loading.Update_Last_Link (I);
      elsif I in Perception_Type_Index'Range then
         Epistemic_Memory.Perceptive.Loading.Load (I, Rule_Storage_Ptr);
      elsif I in Prediction_Type_Index'Range then
         Epistemic_Memory.Predictive.Loading.Load (I, Rule_Storage_Ptr);
      elsif I in Reflective_Type_Index'Range then
         Epistemic_Memory.Reflective.Loading.Load (I, Rule_Storage_Ptr);
      elsif I in Reward_Type_Index'Range then
         Epistemic_Memory.Rewarding.Loading.Load (I, Rule_Storage_Ptr);
      end if;
   end Load;

end Nomo.Interpreter.Epistemic_Memory.Loading;
