--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

limited with Nomo.Interpreter.Storages;

with Nomo.Interpreter.Perceptions_Clusters;

private with Nomo.Interpreter.Perceptions_Clusters.Loading;
pragma Elaborate_All (Nomo.Interpreter.Perceptions_Clusters.Loading);

private with Nomo.Interpreter.Epistemic_Memory.Gen_Section.Loading;
pragma Elaborate_All (Nomo.Interpreter.Epistemic_Memory.Gen_Section.Loading);

package Nomo.Interpreter.Epistemic_Memory.Perceptive.Loading is

   use Perceptions_Clusters;

   function Get_Cluster (I : in Perception_Type_Index) return not null access Perceptions_Cluster;

   function Has_Space (I : in Perception_Type_Index) return Boolean;

   procedure Load (I                : in Perception_Type_Index;
                   Rule_Storage_Ptr : not null access constant Storages.Full_Rule_Storage);

private

   use Perceptions_Clusters.Loading;

   package Perceptive_Epistemic_Memory_Loading is new Perceptive_Epistemic_Memory.Loading (Initialize,
                                                                                           Has_Space,
                                                                                           Load);

   function Has_Space (I : in Perception_Type_Index) return Boolean renames Perceptive_Epistemic_Memory_Loading.Has_Space;

   procedure Load (I                : in Perception_Type_Index;
                   Rule_Storage_Ptr : not null access constant Storages.Full_Rule_Storage) renames Perceptive_Epistemic_Memory_Loading.Load;

   function Gen_Get_Cluster is new Perceptive_Epistemic_Memory_Loading.Get_Cluster;

   function Get_Cluster (I : in Perception_Type_Index) return not null access Perceptions_Cluster renames Gen_Get_Cluster;

end Nomo.Interpreter.Epistemic_Memory.Perceptive.Loading;
