--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Plant.Chunks_Index;

with Nomo.Numerics.Times;

with Nomo.Numerics.Informations;

with Nomo.Interpreter.Types_Index.Ranges;

private package Nomo.Interpreter.Plant.Internal_Chunks_Register is

   use Numerics.Times;
   use Numerics.Informations;
   use Chunks_Index;
   use Types_Index.Ranges;

   procedure Assume_All (T : in Positive_Time);

   procedure Assume_With_Target (I      : in Internal_Chunk_Index;
                                 T      : in Positive_Time;
                                 Target : in Internal_Chunk_Index);

   procedure Cancel;
   pragma Inline (Cancel);

   procedure Create_Perception_Forward (I            : in Internal_Chunk_Index;
                                        Capture_Time : in Positive_Time;
                                        Arrival_Time : in Positive_Time;
                                        Input_Index  : in Input_Type_Index);

   function Get_Arrival_Time (I         : in Internal_Chunk_Index;
                              Operation : in Positive) return Positive_Time;
   pragma Inline (Get_Arrival_Time);

   function Get_Capture_Time (I : in Internal_Chunk_Index) return Positive_Time;
   pragma Inline (Get_Capture_Time);

   function Is_Expired (I : in Internal_Chunk_Index;
                        T : in Positive_Time) return Boolean;
   pragma Inline (Is_Expired);

   procedure Registry;

   procedure Send_In_Conclusion;

   procedure Send_In_Conclusion (Reference_Chunk : in Internal_Chunk_Index);
   pragma Inline (Send_In_Conclusion);

   procedure Send_In_Excitatory_Condition;
   pragma Inline (Send_In_Excitatory_Condition);

   procedure Send_In_Inhibitory_Condition;
   pragma Inline (Send_In_Inhibitory_Condition);

   procedure Set_Operation (I           : in Internal_Chunk_Index;
                            Information : in Positive_Integer);

   procedure Set_Temporal_Reference (I                       : in Internal_Chunk_Index;
                                     Is_Reference_And_Origin : in Boolean);
   pragma Inline (Set_Temporal_Reference);

end Nomo.Interpreter.Plant.Internal_Chunks_Register;
