--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Accurately;

with Nomo.Numerics.Reals;

with Nomo.Numerics.Informations;

with Nomo.Internal_Messages;

private with Nomo.Interpreter.Rules_Base.Spontaneous;

private with Nomo.Internal_Messages.Conclusions.Instantaneous;

private with Nomo.Interpreter.Standard_Conditions;

private package Nomo.Interpreter.Reflection_Rules is

   use Numerics.Accurately;
   use Numerics.Reals;
   use Numerics.Informations;

   type Reflection_Rule is tagged limited private;

   procedure Adjust (This            : in out Reflection_Rule;
                     Specificity_Log : in out Real_Accurately);

   procedure Evaluate (This : in out Reflection_Rule;
                       Score : out Positive_Real);

   procedure Evaluate (This  : in out Reflection_Rule;
                       Shift : in Real_Accurately;
                       Score : out Positive_Real);

   function Get_Instruction (This : in Reflection_Rule) return Positive_Integer;
   pragma Inline (Get_Instruction);

   function Get_Conclusion (This : in Reflection_Rule) return not null access constant Internal_Messages.Internal_Message;
   pragma Inline (Get_Conclusion);

   function Is_Forget (This : in Reflection_Rule) return Boolean;
   pragma Inline (Is_Forget);

   function Is_Updatable (This : in Reflection_Rule) return Boolean;
   pragma Inline (Is_Updatable);

   procedure Reinforce (This     : in out Reflection_Rule;
                        Quantity : in Real_Accurately_0_To_1);

   procedure Update_Relevance (This : in out Reflection_Rule);
   pragma Inline (Update_Relevance);

   procedure Update_Relevance (This       : in out Reflection_Rule;
                               Scores_Sum : in Positive_Real);

private

   use Rules_Base.Spontaneous;
   use Internal_Messages.Conclusions.Instantaneous;
   use Standard_Conditions;

   type Reflection_Rule is new Spontaneous_Rule with record
      Conclusion : aliased Instantaneous_Conclusion;
      Condition  : Standard_Condition;
   end record;

end Nomo.Interpreter.Reflection_Rules;
