--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Internal_Messages.Logging;

with Nomo.Interpreter.Premises_Index.Arrays.Setting;

with Nomo.Interpreter.External_Messages.Setting;

with Nomo.Interpreter.External_Messages.Premises.Setting;

package body Nomo.Interpreter.Storages.Writing is

   procedure Set_Conclusion_Type (This  : out Full_Rule_Storage;
                                   Internal_Type : in Internal_Type_Index) is
   begin
      This.Conclusion_Type := Internal_Type;
   end Set_Conclusion_Type;

   procedure Set_Id (This : out Full_Rule_Storage;
                     Id   : in Positive) is
   begin
      This.Id := Id;
   end Set_Id;

   procedure Set_Internal_Conclusion (This                : out Full_Rule_Storage;
                                      Internal_Conclusion : in Internal_Message) is
      use Internal_Messages.Logging;
   begin
      Set (Internal_Message (This.Internal_Conclusion), Internal_Conclusion);
   end Set_Internal_Conclusion;

   procedure Set_Internal_Premise (This          : out Full_Rule_Storage;
                                   I             : in Premise_Index;
                                   Premise       : in Internal_Premise;
                                   Internal_Type : in Internal_Type_Index) is
      use Premises_Index.Arrays.Setting;
   begin
      Set (This.Internal_Condition, I, Premise);
      Set (This.Internal_Condition_Types, I, Internal_Type);
   end Set_Internal_Premise;

   procedure Set_Condition_Property (This     : out Full_Rule_Storage;
                                     I        : in Premise_Index;
                                     Property : in Premise_Property) is
      use Premises_Index.Arrays.Setting;
   begin
      Set (This.Internal_Condition_Properties, I, Property);
   end Set_Condition_Property;

   procedure Set_Internal_Premises_Number (This            : out Full_Rule_Storage;
                                           Premises_Number : in Premise_Index) is
   begin
      This.Internal_Premises_Number := Premises_Number;
   end Set_Internal_Premises_Number;

   procedure Set_Fitting_Nbr (This        : out Full_Rule_Storage;
                              Fitting_Nbr : in Count) is
   begin
      This.Fitting_Nbr := Fitting_Nbr;
   end Set_Fitting_Nbr;

   procedure Set_Relevance (This      : out Full_Rule_Storage;
                            Relevance : in Real_Accurately_0_To_1) is
   begin
      This.Relevance := Relevance;
   end Set_Relevance;

   procedure Set_Credibility (This        : out Full_Rule_Storage;
                              Credibility : in Real_0_To_1) is
   begin
      This.Credibility := Credibility;
   end Set_Credibility;

   procedure Set_External_Conclusion (This                : in out Full_Rule_Storage;
                                      External_Conclusion : in External_Message) is
      use External_Messages.Setting;
   begin
      Set (External_Message (This.External_Conclusion), External_Conclusion, This.External_Conclusion_Size);
   end Set_External_Conclusion;

   procedure Set_External_Conclusion_Size (This : out Full_Rule_Storage;
                                           Size : in Component_Index) is
   begin
      This.External_Conclusion_Size := Size;
   end Set_External_Conclusion_Size;

   procedure Set_External_Condition (This               : out Full_Rule_Storage;
                                     External_Condition : in External_Premise;
                                     Internal_Type      : in External_Type_Index) is
      use External_Messages.Premises.Setting;
   begin
      Set (This.External_Condition, External_Condition);
      This.External_Condition_Type := Internal_Type;
   end Set_External_Condition;

end Nomo.Interpreter.Storages.Writing;
