--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Type_Categories;

with Nomo.Interpreter.Types_Directory.Initialization;
pragma Elaborate_All(Nomo.Interpreter.Types_Directory.Initialization);

package Nomo.Interpreter.Types_Index.Ranges is

   use Type_Categories;
   use Types_Directory.Initialization;
   use Types_Index_Instance;

   subtype Input_Type_Index is Type_Index range First_Type (Input) .. Last_Type (Input);
   subtype Command_Type_Index is Type_Index range First_Type (Command) .. Last_Type (Command);
   subtype Perception_Type_Index is Type_Index range First_Type (Perception) .. Last_Type (Perception);
   subtype Conception_Type_Index is Type_Index range First_Type (Conception) .. Last_Type (Conception);
   subtype Prediction_Type_Index is Type_Index range First_Type (Prediction) .. Last_Type (Prediction);
   subtype Landmark_Type_Index is Type_Index range First_Type (Landmark) .. Last_Type (Landmark);
   subtype Operator_Type_Index is Type_Index range First_Type (Operator) .. Last_Type (Operator);
   subtype Scope_Type_Index is Type_Index range First_Type (Scope) .. Last_Type (Scope);
   subtype Transition_Type_Index is Type_Index range First_Type (Transition) .. Last_Type (Transition);
   subtype Anomaly_Type_Index is Type_Index range First_Type (Anomaly) .. Last_Type (Anomaly);
   subtype Check_Type_Index is Type_Index range First_Type (Check) .. Last_Type (Check);
   subtype Reward_Type_Index is Type_Index range First_Type (Reward) .. Last_Type (Reward);

   subtype External_Type_Index is Input_Type_Index;
   subtype Internal_Type_Index is Type_Index range Input_Type_Index'Last + 1 .. Type_Index'Last;

   subtype Reflective_Type_Index is Type_Index range Operator_Type_Index'First .. Transition_Type_Index'Last;

end Nomo.Interpreter.Types_Index.Ranges;
