--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

package Nomo.Numerics.Accurately is

   pragma Pure;

   type Real_Accurately is delta 0.00001 digits 9;
   for Real_Accurately'Size use 32;

   subtype Positive_Real_Accurately is Real_Accurately range 0.0 .. Real_Accurately'Last;

   subtype Strictly_Positive_Real_Accurately is Real_Accurately range Real_Accurately'Small .. Real_Accurately'Last;

   type Real_Accurately_0_To_1 is delta 0.000_000_001 digits 10 range 0.0..1.0;
   for Real_Accurately_0_To_1'Size use 32;

end Nomo.Numerics.Accurately;
