import ctypes
from ctypes import cdll
from ctypes import c_int, c_short, c_float, c_char_p, POINTER, CFUNCTYPE

# nomoLogFlag
(NOMO_WINNER_PARTIAL, NOMO_WINNER_FULL, NOMO_ALL_RULE_PARTIAL, NOMO_ALL_RULE_FULL, NOMO_NO_LOG) = range (0, 5) 

# nomoFileFlag
(NOMO_NEW_FULL_FILE, NOMO_NEW_PARTIAL_FILE, NOMO_NEW_FILES, NOMO_ANY_NEW_FILE) = range (0, 4) 

# nomoLogPositionFlag
(NOMO_BEFORE_ASSUME, NOMO_AFTER_ASSUME) = range (0, 2)

# nomoFinalizationFlag
(NOMO_ANY_MODIFICATION, NOMO_SAVE_SEED, NOMO_UPDATE_SEED) = range (0, 3)

nomoCallback = CFUNCTYPE(None, c_float, POINTER (c_float));

try:
	nomoInterpreter = cdll.LoadLibrary('nomointerpreter.dll')
except Exception:
	nomoInterpreter = cdll.LoadLibrary('libnomointerpreter.so')
nomoInitialize = nomoInterpreter.nomoInitialize # (actions, dirLog, dirLength)
nomoInitialize.argtypes = [POINTER (nomoCallback), c_char_p, c_int]
nomoInitialize.restype = None

nomoInput = nomoInterpreter.nomoInput # (id, data)
nomoInput.argtypes = [c_short, POINTER (c_float)]
nomoInput.restype = None

nomoTriggers = nomoInterpreter.nomoTriggers
nomoTriggers.argtypes = None
nomoTriggers.restype = None

nomoTriggersWithLog = nomoInterpreter.nomoTriggersWithLog # (nomoLogFlags, nomoLogPositionFlag, nomoFileFlag)
nomoTriggersWithLog.argtypes = [POINTER (c_int), c_int, c_int]
nomoTriggersWithLog.restype = None

nomoFinalize = nomoInterpreter.nomoFinalize  # (nomoFinalizationFlag)
nomoFinalize.argtypes = [c_int]
nomoFinalize.restype = None