<?xml version="1.0" encoding="utf-8" standalone="yes"?>
<!--
  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published
  by the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program. If not, see <http://www.gnu.org/licenses/>
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sdk="http://www.nomoseed.org/nomosdk" xmlns="http://www.w3.org/2001/XMLSchema">
	<xsl:output method="xml" indent="yes" encoding="utf-8"/>
	<xsl:template match="/sdk:macros">
		<xsl:element name="schema" namespace="http://www.w3.org/2001/XMLSchema">
			<xsl:attribute name="elementFormDefault">
				<xsl:value-of select="'qualified'"/>
			</xsl:attribute>
			<xsl:attribute name="attributeFormDefault">
				<xsl:value-of select="'unqualified'"/>
			</xsl:attribute>
			<xsl:attribute name="targetNamespace">
				<xsl:value-of select="'http://www.nomoseed.org/sdk'"/>
			</xsl:attribute>
			<import namespace="http://www.nomoseed.org/project" schemaLocation="project.xsd"/>
			<import namespace="http://www.w3.org/2001/XInclude" schemaLocation="xinclude.xsd"/>
			<import namespace="http://www.nomoseed.org/template" schemaLocation="template.xsd"/>
			<xsl:for-each select="/sdk:macros/sdk:macro">
				<import namespace="http://www.nomoseed.org/{@name}" schemaLocation="../macros/{@name}/{@name}.xsd"/>
			</xsl:for-each>
			<annotation>
				<documentation xml:lang="en">Copyright © 2013 Cédric Coussinet. All rights reserved.</documentation>
			</annotation>
			<complexType name="macro" abstract="true">
				<sequence>
					<element minOccurs="0" maxOccurs="1" ref="project:annotation" xmlns:project="http://www.nomoseed.org/project"/>
          <element minOccurs="0" maxOccurs="1" name="csv" type="sdk:csv" xmlns:sdk="http://www.nomoseed.org/sdk"/>
				</sequence>
				<attribute name="active" use="required" type="boolean"/>
				<attribute name="name" use="required" type="project:basicName" xmlns:project="http://www.nomoseed.org/project"/>
				<attribute name="scheme" type="project:basicName" use="optional" xmlns:project="http://www.nomoseed.org/project" />
			</complexType>
      <complexType name="csv" abstract="true" mixed="true">
        <attribute name="select" use="optional">
          <simpleType>
            <restriction base="string">
              <pattern value="[1-9]+[0-9]*[ ]+to[ ]+[1-9]+[0-9]*"/>
            </restriction>
          </simpleType>
        </attribute>
      </complexType>
      <complexType name="embedded" mixed="true">
        <simpleContent>
          <restriction base="sdk:csv" xmlns:sdk="http://www.nomoseed.org/sdk">
            <simpleType>
              <restriction base="string">
                <pattern value="[\s]*[a-zA-Z]+[a-zA-Z0-9_]*[ \t]*(,[ \t]*[a-zA-Z]+[a-zA-Z0-9_]*[ \t]*)*(\n[ \t]*([a-zA-Z]+[a-zA-Z0-9_]*|([-+]?[0-9]*\.?[0-9]+([eE][-+]?[0-9]+)?))[ \t]*(,[ \t]*([a-zA-Z]+[a-zA-Z0-9_]*|([-+]?[0-9]*\.?[0-9]+([eE][-+]?[0-9]+)?))[ \t]*)*)*[ \t\n]*"/>
              </restriction>
            </simpleType>
          </restriction>
        </simpleContent>
      </complexType>
      <complexType name="csvExtern" abstract="true" mixed="false">
        <complexContent>
          <restriction base="sdk:csv" xmlns:sdk="http://www.nomoseed.org/sdk"/>
        </complexContent>
      </complexType>
      <complexType name="extern">
        <complexContent>
          <extension base="sdk:csvExtern" xmlns:sdk="http://www.nomoseed.org/sdk">
            <sequence>
              <element ref="xi:include" minOccurs="0" maxOccurs="1" xmlns:xi="http://www.w3.org/2001/XInclude"/>
            </sequence>
          </extension>
        </complexContent>
      </complexType>
			<complexType name="template">
				<complexContent>
					<extension base="sdk:macro" xmlns:sdk="http://www.nomoseed.org/sdk">
						<sequence>
							<element ref="template:template" template:macro="http://www.nomoseed.org/template" minOccurs="1" maxOccurs="1" xmlns:template="http://www.nomoseed.org/template"/>
						</sequence>
					</extension>
				</complexContent>
			</complexType>
			<xsl:for-each select="/sdk:macros/sdk:macro">
				<complexType name="{@name}">
					<complexContent>
						<extension base="sdk:macro" xmlns:sdk="http://www.nomoseed.org/sdk">
							<sequence>
								<xsl:element name="element" namespace="http://www.w3.org/2001/XMLSchema">
									<xsl:attribute name="ref">
										<xsl:value-of select="concat(@name,':', @name)"/>
									</xsl:attribute>
									<xsl:attribute name="{concat(@name,':macro')}" namespace="{concat('http://www.nomoseed.org/',@name)}">
										<xsl:value-of select="concat('http://www.nomoseed.org/',@name)"/>
									</xsl:attribute>
									<xsl:attribute name="minOccurs">
										<xsl:value-of select="1"/>
									</xsl:attribute>
									<xsl:attribute name="maxOccurs">
										<xsl:value-of select="1"/>
									</xsl:attribute>
								</xsl:element>
							</sequence>
						</extension>
					</complexContent>
				</complexType>
			</xsl:for-each>
		</xsl:element>
	</xsl:template>
</xsl:stylesheet>
