--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

package Nomo.Internal_Messages.Conclusions.Delayed.Predictive is

   type Predictive_Conclusion is limited new Delayed.Delayed_Conclusion with private;

   procedure Adjust_Prediction (This      : in out Predictive_Conclusion;
                                Time_Span : in Positive_Time_Interval;
                                Bonus     : in Positive_Time_Interval);

   procedure Adjust_Prediction (This  : in out Predictive_Conclusion;
                                Bonus : in Positive_Time_Interval);

   package Pointer is

      type Predictive_Conclusion_Ptr is access all Predictive_Conclusion;

   end Pointer;

private

   type Predictive_Conclusion is limited new Delayed.Delayed_Conclusion with null record;

end Nomo.Internal_Messages.Conclusions.Delayed.Predictive;
