--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Accurately;

with Nomo.Numerics.Reals;

with Nomo.Numerics.Fitting;

private with Nomo.Interpreter.Integrations_Arrays;

private with Nomo.Gen_External_Messages.Premises;

package Nomo.Interpreter.External_Messages.Premises is

   use Numerics.Accurately;
   use Numerics.Reals;
   use Numerics.Fitting;

   type External_Premise is tagged limited private;

   function Get_Specificity_Log (This : in External_Premise) return Real_Accurately;

   procedure Maximize (This        : in out External_Premise;
                       Fitting_Nbr : in Count);

   function Measure_Distance (This : in External_Premise;
                              Sign : in External_Message) return Positive_Real;

   procedure Note (This : in out External_Premise;
                   Sign : in External_Message);

private

   use Integrations_Arrays;

   package External_Messages_Premises_Instance is new External_Messages_Instance.Premises(External_Message, Integrations_Arrays_Instance);

   type External_Premise is new External_Messages_Premises_Instance.External_Premise with null record;

end Nomo.Interpreter.External_Messages.Premises;
