--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

package Nomo.Numerics.Reals is

   pragma Pure;

   type Real is digits 6 range -16#0.FFFF_FF#E32 .. 16#0.FFFF_FF#E32;
   for Real'Size use 32;
   pragma Convention (C, Real);

   subtype Real_0_To_1 is Real range 0.0 .. 1.0;

   Positive_Infinity : constant Real := Real'Last;
   Negative_Infinity : constant Real := Real'First;

   subtype Positive_Real is Real range 0.0 .. Positive_Infinity;
   subtype Negative_Real is Real range Negative_Infinity .. 0.0;

   Zero_Plus  : constant Real := Real'Model_Small;
   Zero_Minus : constant Real := - Real'Model_Small;

   subtype Strictly_Positive_Real is Real range Zero_Plus .. Positive_Infinity;
   subtype Strictly_Negative_Real is Real range Negative_Infinity .. -Zero_Minus;

end Nomo.Numerics.Reals;
