--  Copyright (2008-2011) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

--  Ce composant permet d'analyser entirement un fichier xml
--  avec un seul analyseur.

package Basic_Sax.File_Parser is

   type Reader is tagged limited null record;

   procedure Start_Element (Handler : in out Reader;
                            Name    : in String;
                            A       : in Attributes) is null;
   --  Procdure  surcharger.
   --  Appelle  chaque balise ouvrante rencontre
   --  ainsi que pour chaque balise singluire.

   procedure End_Element (Handler : in out Reader;
                          Name    : in String) is null;
   --  Procdure  surcharger.
   --  Appelle  chaque balise fermante rencontre.

   procedure Characters (Handler : in out Reader;
                         Data    : in String) is null;
   --  Procdure  surcharger.
   --  Appelle lorque des charactres entre balises sont rencontres.

   procedure Parse (Handler   : in out Reader'Class;
                    File_Name : in String);
   --  Analyse tout le fichier. "File_Name" doit inclure son extension.
   --  Lve "FILE_NAME_ERROR" si le fichier n'est pas trouv.

   FILE_NAME_ERROR : exception;

end Basic_Sax.File_Parser;
