--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>
--
--  Paquetage utilis pour affecter une premise de "Rule_Buffer" et pour
--  initialiser ou rinitialiser ses tendances.

with Nomo.Numerics.Informations;

with Nomo.Numerics.Times;

package Nomo.Internal_Messages.Premises.Plant is

   procedure Adjust_Trend (This        : in out Internal_Premise;
                           Fitting_Nbr : in Count);

   use Numerics.Informations;
   use Numerics.Times;

   procedure Set (This   : out Internal_Premise;
                  Source : in Internal_Premise);

   procedure Set (This                  : out Internal_Premise;
                  Information           : in Positive_Integer;
                  Information_Tolerance : in Boolean;
                  Time_Span             : in Time_Interval;
                  Time_Span_Tolerance   : in Strictly_Positive_Real;
                  Credibility           : in Real_0_To_1;
                  Credibility_Tolerance : in Strictly_Positive_Real);

   procedure Set_Time_Span (This      : in out Internal_Premise;
                            Time_Span : in Time_Interval);
   pragma Inline (Set_Time_Span);

end Nomo.Internal_Messages.Premises.Plant;
