--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Storages;

with Nomo.Interpreter.Beginning;
pragma Elaborate_All (Nomo.Interpreter.Beginning);

private with Nomo.Reader.Gen_Rule_Storages;
pragma Elaborate_All (Nomo.Reader.Gen_Rule_Storages);

package Nomo.Interpreter.Beginning.Rules is

   use Storages;

   subtype Storage_Index is Positive range 1 .. Get_Number_Of_Rules;

   procedure Get_Storage (I       : in Storage_Index;
                          Storage : out Full_Rule_Storage);

private

   package Reader_Rule_Storages is new Reader.Gen_Rule_Storages (Full_Rule_Storage);

   procedure Get_Storage (I       : in Storage_Index;
                          Storage : out Full_Rule_Storage) renames Reader_Rule_Storages.Get_Storage;

end Nomo.Interpreter.Beginning.Rules;
