--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Premises_Index.Arrays.Maximization;

package body Nomo.Interpreter.Conditions_Base is

   function Get_Credibility (This : in Condition_Base) return Real_0_To_1 is
   begin
      return This.Credibility;
   end Get_Credibility;

   function Get_Score (This : in Condition_Base) return Positive_Real is
   begin
      return This.Score;
   end Get_Score;

   function Get_Specificity_Log (This : in Condition_Base) return Real_Accurately is
   begin
      return This.Specificity_Log;
   end Get_Specificity_Log;

   function Is_Optimizable (This : in Condition_Base) return Boolean is
   begin
      return This.Optimizable;
   end Is_Optimizable;

   procedure Maximize (This : in out Condition_Base) is
      use Premises_Index.Arrays.Maximization;
      use Premises_Index.Premises_Index_Instance;
   begin
      This.Specificity_Log := 0.0;
      This.Fitting_Nbr := This.Fitting_Nbr + 1;
      This.Optimizable := This.Fitting_Nbr < Maximum_Of_Maximizations;
      for I in Premises_Index.Focus.Directories.First_Excitator .. This.Directory.Get_Excitator_Last loop
         Maximize(This.Premises, I, This.Fitting_Nbr);
         This.Specificity_Log := This.Specificity_Log + Get_Specificity_Log (This.Premises, I);
      end loop;
      This.Specificity_Log := (This.Specificity_Log + This.Specificity_Log_Min)/2.0;
   end Maximize;

end Nomo.Interpreter.Conditions_Base;
