--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Commands_Clusters.Initialization;

with Nomo.Interpreter.Epistemic_Memory.Gen_Section.Commanding;
pragma Elaborate_All (Nomo.Interpreter.Epistemic_Memory.Gen_Section.Commanding);

with Nomo.Interpreter.Emission_Channels;

package body Nomo.Interpreter.Epistemic_Memory.Commanding.Initialization is

   package Commanding_Epistemic_Memory_Initialization is new Commanding_Epistemic_Memory.Commanding (Commands_Clusters.Initialization.Initialize);

   procedure Initialize (Callbacks : in System.Address) is
      use Commanding_Epistemic_Memory_Initialization;
      type Functions is array (Command_Type_Index'Range) of Emission_Channels.Callback;
      pragma Suppress_Initialization (Functions);
      Actions : Functions;
      for Actions'Address use Callbacks;
   begin
      for I in Command_Type_Index'Range loop
         Initialize (I, Actions (I));
      end loop;
   end Initialize;

end Nomo.Interpreter.Epistemic_Memory.Commanding.Initialization;
