--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Times;

with Nomo.Numerics.Accurately;

with Nomo.Interpreter.Types_Index.Ranges;

package Nomo.Interpreter.Epistemic_Memory.Reinforcement is

   use Types_Index.Ranges;
   use Numerics.Times;
   use Numerics.Accurately;

   procedure Reinforce (I               : in Internal_Type_Index;
                        T               : in Positive_Time;
                        First_Landmark  : in Positive_Time_Interval;
                        Second_Landmark : in Positive_Time_Interval;
                        Quantity        : in Real_Accurately_0_To_1);
   pragma Precondition ( not (I in Anomaly_Type_Index or I in Check_Type_Index or I in Reward_Type_Index));

end Nomo.Interpreter.Epistemic_Memory.Reinforcement;
