--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>
--
--  Ce composant correspond  la mmoire des items. Les items correspondent
--   des variables qui sont affect par l'intermdiare des curseurs ou oprateur
--  de construction.
--  Ces items serviront par la suite  affecter le stockage de la future rgle.

with Nomo.Numerics.Times;

with Nomo.Numerics.Informations;

with Nomo.Interpreter.Plant.Chunks_Index;

private package Nomo.Interpreter.Plant.Chunks_Memory is

   use Numerics.Informations;
   use Chunks_Index;

   procedure Active_Chunk (I         : in Chunk_Index;
                           Operation : in Positive_Integer);

   procedure Cancel;

   procedure End_Affectations;

   procedure New_Affectations;

   procedure Send_In_Conclusion;

   procedure Send_In_Excitatory_Condition;

   procedure Send_In_Inhibitory_Condition;

   use Numerics.Times;

   procedure Update_Affectations (T : in Positive_Time);

end Nomo.Interpreter.Plant.Chunks_Memory;
