--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Informations;

with Nomo.Numerics.Times;

with Nomo.Interpreter.Internal_Events_Index;

with Nomo.Interpreter.Plant.Targets;

with Nomo.Interpreter.Types_Index.Ranges;

private package Nomo.Interpreter.Plant.Internal_Pointers is

   use Targets;
   use Numerics.Informations;
   use Numerics.Times;
   use Internal_Events_Index;
   use Types_Index.Ranges;

   type Internal_Pointer is tagged limited private;

   function Get_Type_Index (This : in Internal_Pointer) return Internal_Type_Index;
   pragma Inline (Get_Type_Index);

   procedure Get_Target (This          : in Internal_Pointer;
                         Chunck_Target : out Target);

   function Get_Event_Position (This : in Internal_Pointer) return Internal_Event_Index;
   pragma Inline (Get_Event_Position);

   function Is_Expired (This : in Internal_Pointer;
                        T    : in Positive_Time) return Boolean;

   procedure Set_Scope (This        : out Internal_Pointer;
                        Information : in Positive_Integer);
   pragma Inline (Set_Scope);

   procedure Update_Position (This : in out Internal_Pointer;
                              T    : in Positive_Time);

private

   type Internal_Pointer is new Target with record
      Scope_Index    : Positive;
      Point_Evidence : Boolean;
      Event_Position : Internal_Event_Index;
   end record;

end Nomo.Interpreter.Plant.Internal_Pointers;
