//  Copyright (2010-2013) Cédric Coussinet (cedric.coussinet@nomoseed.net)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published
//  by the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program. If not, see <http://www.gnu.org/licenses/>

#ifndef MODULE_H
#define MODULE_H

#include <QtGui/qmainwindow.h>
#include <QtWebKit/QWebView>
#include <QObject>

template <typename T>
class Module : public QObject
{

    public:

      static T *getInstance (QMainWindow * mainWindow, QWebView * webView)
      {
        if (NULL == module)
          {
            module = new T(mainWindow, webView);
          }
        return (static_cast<T*> (module));
      }

      static void kill ()
      {
        if (NULL != module)
          {
            delete module;
            module = NULL;
          }
      }

    protected:

      QMainWindow * mainWindow;
      QWebView * webView;

    private:

      static T *module;
};

template <typename T>
T *Module<T>::module = NULL;

#endif // MODULE_H
