--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Interpreter.Event_Memory.Internal.Intuition;

package body Nomo.Interpreter.Commands_Clusters is

   procedure Interpret (This : in out Commands_Cluster) is
   begin
      Cluster_Base (This).Interpret;
   end Interpret;

   procedure Reinforce (This            : in out Commands_Cluster;
                        T               : in Positive_Time;
                        First_Landmark  : in Positive_Time_Interval;
                        Second_Landmark : in Positive_Time_Interval;
                        Quantity        : in Real_Accurately_0_To_1) is
   begin
      This.Activations.Reinforce (T, First_Landmark, Second_Landmark, Quantity);
   end Reinforce;

   procedure Assume (This : in out Commands_Cluster;
                     T    : in Positive_Time) is
      Selected_Rule : Command_Rule renames This.Get_Selected_Rule.all;
   begin
      if Selected_Rule.Is_Upgradable then
         Selected_Rule.Update_External_Conclusion;
      end if;
      This.Action.Put (Selected_Rule.Get_Intensity,
                       Selected_Rule.Get_External_Conclusion);
      This.Activations.Set_Activation_Last (This.Get_Selected_Rule, T);
      Event_Memory.Internal.Intuition.Put_Event (This.Command_Type, Selected_Rule.Get_Internal_Conclusion.all, T);
   end Assume;

   function Has_Selection (This : in Commands_Cluster) return Boolean is
   begin
      return Cluster_Base (This).Has_Selection;
   end Has_Selection;

end Nomo.Interpreter.Commands_Clusters;
