--  Copyright (2008-2013) Cdric Coussinet (cedric.coussinet@nomoseed.net)
--
--  This program is free software: you can redistribute it and/or modify
--  it under the terms of the GNU Affero General Public License as published
--  by the Free Software Foundation, either version 3 of the License, or
--  (at your option) any later version.
--
--  This program is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
--  GNU Affero General Public License for more details.

--  You should have received a copy of the GNU Affero General Public License
--  along with this program. If not, see <http://www.gnu.org/licenses/>

with Nomo.Numerics.Accurately;
use Nomo.Numerics.Accurately;

with Nomo.Numerics.Reals;
use Nomo.Numerics.Reals;

private with Nomo.Interpreter.Gen_Rules_Directories.Standard;
pragma Elaborate_All (Nomo.Interpreter.Gen_Rules_Directories.Standard);

private with Nomo.Interpreter.Internal_Events_Index.Matchmakers;

private generic
   type Rule is limited private;
   type Rule_Ptr is access all Rule;
   Rules_Number : Positive;
   with procedure Adjust (This            : in out Rule;
                          Specificity_Log : in out Real_Accurately);
   with procedure Evaluate (This  : in out Rule;
                            Score : out Positive_Real);
   with procedure Evaluate (This  : in out Rule;
                            Shift : in Real_Accurately;
                            Score : out Positive_Real);
   with function Is_Forget (This : in Rule) return Boolean;
   with function Is_Updatable (This : in Rule) return Boolean;
   with procedure Update_Relevance (This : in out Rule);
   with procedure Update_Relevance (This       : in out Rule;
                                    Scores_Sum : in Strictly_Positive_Real);
package Nomo.Interpreter.Gen_Clusters_Base is

   type Cluster_Base is abstract tagged limited private;

   function Get_Selected_Rule (This : in Cluster_Base) return not null Rule_Ptr;
   pragma Inline (Get_Selected_Rule);

   function Has_Selection (This : in Cluster_Base) return Boolean;
   pragma Inline (Has_Selection);

   procedure Interpret (This : in out Cluster_Base);
   pragma Inline (Interpret);

   procedure Update_Relevance (This : in out Cluster_Base);
   pragma Inline (Update_Relevance);

private

   package Local_Rules_Directories is new Gen_Rules_Directories (Rule,
                                                                 Rule_Ptr,
                                                                 Rules_Number);
   use Local_Rules_Directories;

   package Local_Standard_Directories is new Local_Rules_Directories.Standard (Adjust,
                                                                               Evaluate,
                                                                               Evaluate,
                                                                               Is_Updatable,
                                                                               Is_Forget,
                                                                               Update_Relevance,
                                                                               Update_Relevance);
   use Local_Standard_Directories;

   type Rule_Index is new Positive range 1..Rules_Number;

   type Rules_Store is array (Rule_Index'Range) of aliased Rule;

   type Cluster_Base is abstract tagged limited record
      Matchmaker    : aliased Internal_Events_Index.Matchmakers.Matchmaker;
      Directory     : Standard_Directory;
      Store         : aliased Rules_Store;
      Selected_Rule : Rule_Ptr := null;
   end record;

end Nomo.Interpreter.Gen_Clusters_Base;
